/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.integrations;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.events.BlockAccessEvent;
import de.sean.blockprot.bukkit.events.BlockAccessMenuEvent;
import de.sean.blockprot.bukkit.events.BlockLockOnPlaceEvent;
import de.sean.blockprot.bukkit.integrations.PluginIntegration;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorldGuardIntegration
extends PluginIntegration
implements Listener {
    private static final String FLAG_NAME = "allow-blockprot";
    private static final String CONFIG_ENABLE_FLAG_FUNCTIONALITY = "enable_flag_functionality";
    private boolean enabled = false;
    @Nullable
    private StateFlag allowFlag;

    public WorldGuardIntegration() {
        super("worldguard");
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void registerFlags() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            this.allowFlag = new StateFlag(FLAG_NAME, true);
            registry.register((Flag)this.allowFlag);
        }
        catch (Exception e) {
            BlockProt.getInstance().getLogger().warning("Another plugin has already registered the allow-blockprot flag.\nFunctionality of this plugin might not be as expected due to flag conflicts.\nPlease check if you accidentally installed BlockProt twice.");
        }
    }

    @Override
    public void load() {
        try {
            this.registerFlags();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public void enable() {
        Plugin wg = this.getPlugin();
        if (wg == null || !wg.isEnabled()) {
            return;
        }
        if (this.enableFlagFunctionality()) {
            this.registerListener(this);
        }
        this.enabled = this.allowFlag != null;
    }

    @Override
    @Nullable
    public Plugin getPlugin() {
        return BlockProt.getInstance().getPlugin("WorldGuard");
    }

    private boolean enableFlagFunctionality() {
        return !this.configuration.contains(CONFIG_ENABLE_FLAG_FUNCTIONALITY) || this.configuration.getBoolean(CONFIG_ENABLE_FLAG_FUNCTIONALITY);
    }

    private boolean checkIfDisallowedAtLocation(@NotNull org.bukkit.World world, @NotNull Location location) {
        World wgWorld;
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regions = container.get(wgWorld = BukkitAdapter.adapt((org.bukkit.World)world));
        if (regions != null) {
            BlockVector3 vec = BukkitAdapter.asBlockVector((Location)location);
            ApplicableRegionSet applicableRegions = regions.getApplicableRegions(vec);
            for (ProtectedRegion r : applicableRegions) {
                if (r.getFlag((Flag)this.allowFlag) != StateFlag.State.DENY) continue;
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void onAccess(@NotNull BlockAccessEvent event) {
        if (this.checkIfDisallowedAtLocation(event.getBlock().getWorld(), event.getBlock().getLocation())) {
            event.setBypassProtections(true);
        }
    }

    @EventHandler
    public void onAccessMenu(@NotNull BlockAccessMenuEvent event) {
        if (this.checkIfDisallowedAtLocation(event.getBlock().getWorld(), event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLockOnPlace(@NotNull BlockLockOnPlaceEvent event) {
        if (this.checkIfDisallowedAtLocation(event.getBlock().getWorld(), event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }
}

