/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import com.google.common.collect.ImmutableList;
import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.inventories.BlockLockInventory;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import de.sean.blockprot.bukkit.nbt.FriendHandler;
import de.sean.blockprot.bukkit.nbt.FriendSupportingHandler;
import de.sean.blockprot.bukkit.nbt.RedstoneSettingsHandler;
import de.sean.blockprot.bukkit.squirrelid.Profile;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BlockInfoInventory
extends BlockProtInventory {
    private final int maxSkulls = this.getSize() - 9;

    @Override
    int getSize() {
        return 54;
    }

    @Override
    @NotNull
    String getTranslatedInventoryName() {
        return Translator.get(TranslationKey.INVENTORIES__BLOCK_INFO);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        switch (item.getType()) {
            case BLACK_STAINED_GLASS_PANE: {
                if (state.getBlock() == null) break;
                state.currentPageIndex = 0;
                BlockNBTHandler handler = this.getNbtHandlerOrNull(state.getBlock());
                this.closeAndOpen((HumanEntity)player, handler == null ? null : new BlockLockInventory().fill(player, state.getBlock().getType(), handler));
                break;
            }
            case CYAN_STAINED_GLASS_PANE: {
                if (state.getBlock() == null || state.currentPageIndex < 1) break;
                --state.currentPageIndex;
                BlockNBTHandler handler = this.getNbtHandlerOrNull(state.getBlock());
                this.closeAndOpen((HumanEntity)player, handler == null ? null : this.fill(player, handler));
                break;
            }
            case BLUE_STAINED_GLASS_PANE: {
                ItemStack lastFriendInInventory;
                if (state.getBlock() == null || (lastFriendInInventory = this.inventory.getItem(this.maxSkulls - 1)) == null || lastFriendInInventory.getAmount() == 0) break;
                ++state.currentPageIndex;
                BlockNBTHandler handler = this.getNbtHandlerOrNull(state.getBlock());
                this.closeAndOpen((HumanEntity)player, handler == null ? null : this.fill(player, handler));
            }
        }
        event.setCancelled(true);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
    }

    @NotNull
    public Inventory fill(Player player, BlockNBTHandler handler) {
        InventoryState state = InventoryState.get(player.getUniqueId());
        if (state == null) {
            return this.inventory;
        }
        String owner = handler.getOwner();
        List<FriendHandler> friends = handler.getFriends();
        state.friendResultCache.clear();
        this.inventory.clear();
        int pageOffset = this.maxSkulls * state.currentPageIndex;
        for (int i = 0; i < Math.min(friends.size() - pageOffset, this.maxSkulls); ++i) {
            String uuid = friends.get(pageOffset + i).getName();
            if (friends.get(pageOffset + i).doesRepresentPublic()) {
                this.setItemStack(9 + i, Material.PLAYER_HEAD, TranslationKey.INVENTORIES__FRIENDS__THE_PUBLIC);
            } else {
                this.setItemStack(9 + i, Material.SKELETON_SKULL, uuid);
            }
            state.friendResultCache.add(UUID.fromString(uuid));
        }
        if (!owner.isEmpty()) {
            try {
                Profile profile = BlockProt.getProfileService().findByUuid(UUID.fromString(owner));
                assert (profile != null);
                this.setPlayerSkull(0, Bukkit.getServer().createPlayerProfile(profile.getUniqueId(), profile.getName()));
            }
            catch (Exception e) {
                BlockProt.getInstance().getLogger().warning("Failed to update PlayerProfile: " + e.getMessage());
            }
        }
        this.setItemStack(1, Material.OAK_SIGN, handler.getName());
        this.setItemStack(6, Material.CYAN_STAINED_GLASS_PANE, TranslationKey.INVENTORIES__LAST_PAGE);
        this.setItemStack(7, Material.BLUE_STAINED_GLASS_PANE, TranslationKey.INVENTORIES__NEXT_PAGE);
        RedstoneSettingsHandler redstoneSettingsHandler = handler.getRedstoneHandler();
        this.setEnchantedOptionItemStack(2, Material.REDSTONE, TranslationKey.INVENTORIES__REDSTONE__REDSTONE_PROTECTION, redstoneSettingsHandler.getCurrentProtection());
        this.setEnchantedOptionItemStack(3, Material.HOPPER, TranslationKey.INVENTORIES__REDSTONE__HOPPER_PROTECTION, redstoneSettingsHandler.getHopperProtection());
        this.setEnchantedOptionItemStack(4, Material.PISTON, TranslationKey.INVENTORIES__REDSTONE__PISTON_PROTECTION, redstoneSettingsHandler.getPistonProtection());
        this.setBackButton(8);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BlockProt.getInstance(), () -> {
            try {
                ImmutableList<Profile> profiles = BlockProt.getProfileService().findAllByUuid(state.friendResultCache);
                int offset = state.friendResultCache.contains(FriendSupportingHandler.publicUuid) ? 1 : 0;
                for (int i = 0; i < Math.min(this.maxSkulls, profiles.size()); ++i) {
                    Profile profile = (Profile)profiles.get(i);
                    if (profile.getUniqueId().equals(FriendSupportingHandler.publicUuid)) continue;
                    this.setPlayerSkull(9 + offset + i, Bukkit.getServer().createPlayerProfile(profile.getUniqueId(), profile.getName()));
                }
            }
            catch (Exception e) {
                BlockProt.getInstance().getLogger().warning("Failed to update PlayerProfile: " + e.getMessage());
            }
        });
        return this.inventory;
    }
}

