/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockInspectContentsInventory
extends BlockProtInventory {
    private final InventoryHolder sourceInventory;

    public BlockInspectContentsInventory(@NotNull Player player) {
        super(false);
        InventoryState state = InventoryState.get(player.getUniqueId());
        if (state == null) {
            throw new RuntimeException("Attempting to create a inventory with no inventory state available.");
        }
        if (!(state.getBlock().getState() instanceof InventoryHolder)) {
            throw new RuntimeException("Attempting to create a contents inventory for a block without an inventory.");
        }
        this.sourceInventory = (InventoryHolder)state.getBlock().getState();
        InventoryType type = this.sourceInventory.getInventory().getType();
        this.inventory = type == InventoryType.CHEST ? this.createInventory() : Bukkit.createInventory((InventoryHolder)this, (InventoryType)this.sourceInventory.getInventory().getType());
    }

    @Override
    int getSize() {
        return this.sourceInventory.getInventory().getSize();
    }

    @Override
    @Nullable
    final String getTranslatedInventoryName() {
        return null;
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        event.setCancelled(true);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
    }

    public Inventory fill() {
        this.inventory.setContents(this.sourceInventory.getInventory().getContents());
        return this.inventory;
    }
}

