/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.Permissions;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.events.BlockAccessMenuEvent;
import de.sean.blockprot.bukkit.inventories.BlockInfoInventory;
import de.sean.blockprot.bukkit.inventories.BlockInspectContentsInventory;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.FriendManageInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.inventories.RedstoneSettingsInventory;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import de.sean.blockprot.bukkit.nbt.PlayerInventoryClipboard;
import de.sean.blockprot.bukkit.shaded.anvilgui.AnvilGUI;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTContainer;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BlockLockInventory
extends BlockProtInventory {
    @Override
    int getSize() {
        return 18;
    }

    @Override
    @NotNull
    String getTranslatedInventoryName() {
        return Translator.get(TranslationKey.INVENTORIES__BLOCK_LOCK);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        Block block = state.getBlock();
        if (block == null) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (BlockProt.getDefaultConfig().isLockable(block.getType()) && event.getSlot() == 0) {
            this.applyChanges(player, handler -> handler.lockBlock(player), null);
            this.closeAndOpen((HumanEntity)player, null);
        } else {
            switch (item.getType()) {
                case PLAYER_HEAD: {
                    this.closeAndOpen((HumanEntity)player, new FriendManageInventory().fill(player));
                    break;
                }
                case REDSTONE: {
                    BlockNBTHandler handler2 = this.getNbtHandlerOrNull(block);
                    this.closeAndOpen((HumanEntity)player, handler2 == null ? null : new RedstoneSettingsInventory().fill(player, state));
                    break;
                }
                case OAK_SIGN: {
                    BlockNBTHandler handler3 = this.getNbtHandlerOrNull(block);
                    this.closeAndOpen((HumanEntity)player, handler3 == null ? null : new BlockInfoInventory().fill(player, handler3));
                    break;
                }
                case KNOWLEDGE_BOOK: {
                    BlockNBTHandler handler4 = this.getNbtHandlerOrNull(block);
                    NBTContainer container = PlayerInventoryClipboard.get(player.getUniqueId().toString());
                    if (handler4 == null || container == null) break;
                    handler4.pasteNbt(container);
                    break;
                }
                case PAPER: {
                    BlockNBTHandler handler5 = this.getNbtHandlerOrNull(block);
                    if (handler5 == null) break;
                    PlayerInventoryClipboard.set(player.getUniqueId().toString(), handler5.getNbtCopy());
                    this.closeAndOpen((HumanEntity)player, null);
                    break;
                }
                case NAME_TAG: {
                    player.closeInventory();
                    new AnvilGUI.Builder().text("Block name").title(Translator.get(TranslationKey.INVENTORIES__SET_BLOCK_NAME)).plugin((Plugin)BlockProt.getInstance()).onClick((slot, snapshot) -> {
                        if (slot != 2) {
                            return Collections.emptyList();
                        }
                        InventoryState invState = InventoryState.get(snapshot.getPlayer().getUniqueId());
                        assert (invState.getBlock() != null);
                        new BlockNBTHandler(invState.getBlock()).setName(snapshot.getText());
                        Inventory inventory = new BlockLockInventory().fill(player, block.getType(), new BlockNBTHandler(block));
                        if (inventory == null) {
                            return List.of(AnvilGUI.ResponseAction.close());
                        }
                        return List.of(AnvilGUI.ResponseAction.openInventory(inventory));
                    }).open(player);
                    break;
                }
                case SPYGLASS: {
                    this.closeAndOpen((HumanEntity)player, new BlockInspectContentsInventory(player).fill());
                    break;
                }
                default: {
                    this.closeAndOpen((HumanEntity)player, null);
                }
            }
        }
        event.setCancelled(true);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
    }

    public Inventory fill(@NotNull Player player, Material material, BlockNBTHandler handler) {
        int rightItemOffset;
        InventoryState state = InventoryState.get(player.getUniqueId());
        if (state == null) {
            return this.inventory;
        }
        boolean isNotProtected = handler.isNotProtected();
        if (isNotProtected && state.menuPermissions.size() == 1 && state.menuPermissions.contains((Object)BlockAccessMenuEvent.MenuPermission.INFO)) {
            return null;
        }
        if (state.menuPermissions.contains((Object)BlockAccessMenuEvent.MenuPermission.LOCK)) {
            this.setItemStack(0, this.getProperMaterial(material), isNotProtected ? TranslationKey.INVENTORIES__LOCK : TranslationKey.INVENTORIES__UNLOCK);
        }
        int n = rightItemOffset = !isNotProtected && !handler.isOwner(player.getUniqueId()) && state.getBlock().getState() instanceof InventoryHolder && player.hasPermission(Permissions.ADMIN.key()) ? 1 : 0;
        if (rightItemOffset == 1) {
            this.setItemStack(this.getSize() - 2, Material.SPYGLASS, TranslationKey.INVENTORIES__INSPECT_CONTENTS);
        }
        if (!isNotProtected && state.menuPermissions.contains((Object)BlockAccessMenuEvent.MenuPermission.MANAGER)) {
            int offset = 1;
            this.setItemStack(offset++, Material.REDSTONE, TranslationKey.INVENTORIES__REDSTONE__SETTINGS);
            if (!BlockProt.getDefaultConfig().isFriendFunctionalityDisabled()) {
                this.setItemStack(offset++, Material.PLAYER_HEAD, TranslationKey.INVENTORIES__FRIENDS__MANAGE);
            }
            this.setItemStack(offset, Material.NAME_TAG, TranslationKey.INVENTORIES__SET_BLOCK_NAME);
            if (PlayerInventoryClipboard.contains(player.getUniqueId().toString())) {
                this.setItemStack(this.getSize() - 4 - rightItemOffset, Material.KNOWLEDGE_BOOK, TranslationKey.INVENTORIES__PASTE_CONFIGURATION);
            }
            this.setItemStack(this.getSize() - 3 - rightItemOffset, Material.PAPER, TranslationKey.INVENTORIES__COPY_CONFIGURATION);
        }
        if (!isNotProtected && state.menuPermissions.contains((Object)BlockAccessMenuEvent.MenuPermission.INFO)) {
            this.setItemStack(this.getSize() - 2 - rightItemOffset, Material.OAK_SIGN, TranslationKey.INVENTORIES__BLOCK_INFO);
        }
        this.setBackButton();
        return this.inventory;
    }
}

