/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import de.sean.blockprot.bukkit.nbt.FriendSupportingHandler;
import de.sean.blockprot.bukkit.nbt.PlayerSettingsHandler;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTCompound;
import de.sean.blockprot.nbt.FriendModifyAction;
import de.sean.blockprot.nbt.LockReturnValue;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockProtInventory
implements InventoryHolder {
    protected Inventory inventory;

    @Deprecated
    public BlockProtInventory() {
        this.inventory = this.createInventory();
    }

    public BlockProtInventory(boolean createInventory) {
        if (createInventory) {
            this.inventory = this.createInventory();
        }
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }

    abstract int getSize();

    @Nullable
    abstract String getTranslatedInventoryName();

    @Nullable
    public final String getDefaultInventoryName() {
        String inventoryName = this.getTranslatedInventoryName();
        if (inventoryName == null) {
            return null;
        }
        return inventoryName.isEmpty() ? this.getClass().getSimpleName() : inventoryName;
    }

    public abstract void onClick(@NotNull InventoryClickEvent var1, @NotNull InventoryState var2);

    public abstract void onClose(@NotNull InventoryCloseEvent var1, @NotNull InventoryState var2);

    @NotNull
    protected final Inventory createInventory() {
        String name = this.getDefaultInventoryName();
        if (name != null) {
            return Bukkit.createInventory((InventoryHolder)this, (int)this.getSize(), (String)name);
        }
        return Bukkit.createInventory((InventoryHolder)this, (int)this.getSize());
    }

    @NotNull
    protected final Inventory createInventory(@NotNull String title) {
        return Bukkit.createInventory((InventoryHolder)this, (int)this.getSize(), (String)title);
    }

    @Deprecated
    protected final void modifyFriendsForAction(@NotNull Player player, @NotNull OfflinePlayer friend, @NotNull FriendModifyAction action) {
        this.applyChanges(player, handler -> handler.modifyFriends(player.getUniqueId().toString(), friend.getUniqueId().toString(), action), handler -> {
            switch (action) {
                case ADD_FRIEND: {
                    handler.addFriend(friend.getUniqueId().toString());
                    break;
                }
                case REMOVE_FRIEND: {
                    handler.removeFriend(friend.getUniqueId().toString());
                }
            }
        });
    }

    protected final void modifyFriendsForAction(@NotNull Player player, @NotNull UUID friend, @NotNull FriendModifyAction action) {
        this.applyChanges(player, handler -> handler.modifyFriends(player.getUniqueId().toString(), friend.toString(), action), handler -> {
            switch (action) {
                case ADD_FRIEND: {
                    handler.addFriend(friend.toString());
                    break;
                }
                case REMOVE_FRIEND: {
                    handler.removeFriend(friend.toString());
                }
            }
        });
    }

    protected void applyChanges(@NotNull Player player, @Nullable Function<BlockNBTHandler, LockReturnValue> onBlockChanges, @Nullable Consumer<PlayerSettingsHandler> onSettingsChanges) {
        InventoryState state = InventoryState.get(player.getUniqueId());
        switch (state.friendSearchState) {
            case FRIEND_SEARCH: {
                if (onBlockChanges == null) {
                    return;
                }
                assert (state.getBlock() != null);
                BlockNBTHandler nbtHandler = this.getNbtHandlerOrNull(state.getBlock());
                if (nbtHandler == null) {
                    return;
                }
                LockReturnValue ret = onBlockChanges.apply(nbtHandler);
                if (!ret.success) break;
                nbtHandler.applyToOtherContainer();
                break;
            }
            case DEFAULT_FRIEND_SEARCH: {
                if (onSettingsChanges == null) {
                    return;
                }
                PlayerSettingsHandler settingsHandler = new PlayerSettingsHandler(player);
                onSettingsChanges.accept(settingsHandler);
            }
        }
    }

    protected int findItemIndex(@NotNull ItemStack item) {
        ItemStack[] contents = this.inventory.getContents();
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            ItemStack stack = contents[i];
            if (stack == null || !stack.equals((Object)item)) continue;
            return i;
        }
        return -1;
    }

    public void setBackButton() {
        this.setBackButton(this.inventory.getSize() - 1);
    }

    public void setBackButton(int index) {
        this.setItemStack(index, Material.BLACK_STAINED_GLASS_PANE, TranslationKey.INVENTORIES__BACK);
    }

    public void setItemStack(int index, Material material, TranslationKey key) {
        this.setItemStack(index, material, Translator.get(key));
    }

    public void setItemStack(int index, Material material, TranslationKey key, List<String> lore) {
        this.setItemStack(index, material, Translator.get(key), lore);
    }

    public void setItemStack(int index, Material material, String text) {
        this.setItemStack(index, material, text, Collections.emptyList());
    }

    public void setItemStack(int index, Material material, String text, List<String> lore) {
        ItemStack stack = new ItemStack(material, 1);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(material);
        }
        assert (meta != null);
        meta.setDisplayName(text);
        if (!lore.isEmpty()) {
            meta.setLore(lore);
        }
        stack.setItemMeta(meta);
        this.inventory.setItem(index, stack);
    }

    public void setEnchantedItemStack(int index, Material material, TranslationKey key, boolean value) {
        ItemStack stack = new ItemStack(material, 1);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            Bukkit.getItemFactory().getItemMeta(material);
        }
        if (meta != null) {
            meta.setDisplayName(Translator.get(key));
            stack.setItemMeta(meta);
        }
        this.toggleEnchants(stack, value);
        this.inventory.setItem(index, stack);
    }

    @Deprecated
    public void setPlayerSkull(int index, OfflinePlayer player) {
        ItemStack stack = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)stack.getItemMeta();
        if (meta == null) {
            meta = (SkullMeta)Bukkit.getItemFactory().getItemMeta(Material.PLAYER_HEAD);
        }
        try {
            assert (meta != null);
            meta.setOwningPlayer(player);
            meta.setDisplayName(player.getName());
        }
        catch (Exception e) {
            BlockProt.getInstance().getLogger().severe("Failed to set skull head for \"" + player.getName() + "\": " + e.getMessage());
        }
        stack.setItemMeta((ItemMeta)meta);
        this.inventory.setItem(index, stack);
    }

    public void setPlayerSkull(int index, @Nullable PlayerProfile profile) {
        ItemStack stack = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta meta = (SkullMeta)stack.getItemMeta();
        if (meta == null) {
            meta = (SkullMeta)Bukkit.getItemFactory().getItemMeta(Material.PLAYER_HEAD);
        }
        try {
            assert (meta != null);
            meta.setOwnerProfile(profile);
            if (profile != null && profile.getName() != null) {
                meta.setDisplayName(profile.getName());
            }
        }
        catch (Exception e) {
            BlockProt.getInstance().getLogger().severe("Failed to set skull head for \"" + (profile == null ? "" : profile.getName()) + "\": " + e.getMessage());
        }
        stack.setItemMeta((ItemMeta)meta);
        this.inventory.setItem(index, stack);
    }

    protected void closeAndOpen(@NotNull HumanEntity player, @Nullable Inventory inventory) {
        if (inventory != null) {
            player.openInventory(inventory);
        } else {
            player.closeInventory();
            InventoryState.remove(player.getUniqueId());
        }
    }

    protected Material getProperMaterial(Material material) {
        return switch (material) {
            case Material.ACACIA_WALL_SIGN -> Material.ACACIA_SIGN;
            case Material.BAMBOO_WALL_SIGN -> Material.BAMBOO_SIGN;
            case Material.BIRCH_WALL_SIGN -> Material.BIRCH_SIGN;
            case Material.CHERRY_WALL_SIGN -> Material.CHERRY_SIGN;
            case Material.CRIMSON_WALL_SIGN -> Material.CRIMSON_SIGN;
            case Material.DARK_OAK_WALL_SIGN -> Material.DARK_OAK_SIGN;
            case Material.JUNGLE_WALL_SIGN -> Material.JUNGLE_SIGN;
            case Material.MANGROVE_WALL_SIGN -> Material.MANGROVE_SIGN;
            case Material.OAK_WALL_SIGN -> Material.OAK_SIGN;
            case Material.SPRUCE_WALL_SIGN -> Material.SPRUCE_SIGN;
            case Material.WARPED_WALL_SIGN -> Material.WARPED_SIGN;
            case Material.ACACIA_WALL_HANGING_SIGN -> Material.ACACIA_HANGING_SIGN;
            case Material.BAMBOO_WALL_HANGING_SIGN -> Material.BAMBOO_HANGING_SIGN;
            case Material.BIRCH_WALL_HANGING_SIGN -> Material.BIRCH_HANGING_SIGN;
            case Material.CHERRY_WALL_HANGING_SIGN -> Material.CHERRY_HANGING_SIGN;
            case Material.CRIMSON_WALL_HANGING_SIGN -> Material.CRIMSON_HANGING_SIGN;
            case Material.DARK_OAK_WALL_HANGING_SIGN -> Material.DARK_OAK_HANGING_SIGN;
            case Material.JUNGLE_WALL_HANGING_SIGN -> Material.JUNGLE_HANGING_SIGN;
            case Material.MANGROVE_WALL_HANGING_SIGN -> Material.MANGROVE_HANGING_SIGN;
            case Material.OAK_WALL_HANGING_SIGN -> Material.OAK_HANGING_SIGN;
            case Material.SPRUCE_WALL_HANGING_SIGN -> Material.SPRUCE_HANGING_SIGN;
            case Material.WARPED_WALL_HANGING_SIGN -> Material.WARPED_HANGING_SIGN;
            default -> material;
        };
    }

    @Nullable
    protected BlockNBTHandler getNbtHandlerOrNull(@Nullable Block block) {
        if (block == null) {
            return null;
        }
        try {
            return new BlockNBTHandler(block);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Nullable
    protected FriendSupportingHandler<NBTCompound> getFriendSupportingHandler(@NotNull InventoryState.FriendSearchState state, @Nullable Player player, @Nullable Block block) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case InventoryState.FriendSearchState.FRIEND_SEARCH -> {
                if (block == null) {
                    yield null;
                }
                yield this.getNbtHandlerOrNull(block);
            }
            case InventoryState.FriendSearchState.DEFAULT_FRIEND_SEARCH -> player == null ? null : new PlayerSettingsHandler(player);
        };
    }

    @Deprecated
    protected ItemStack toggleEnchants(@NotNull ItemStack stack) {
        return this.toggleEnchants(stack, null);
    }

    @Deprecated
    @NotNull
    protected ItemStack toggleEnchants(@NotNull ItemStack stack, @Nullable Boolean toggle) {
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(stack.getType());
        }
        if (meta != null) {
            if (meta.hasEnchants() && (toggle == null || !toggle.booleanValue())) {
                meta.removeEnchant(Enchantment.INFINITY);
            } else if (!meta.hasEnchants() && (toggle == null || toggle.booleanValue())) {
                meta.addEnchant(Enchantment.INFINITY, 1, true);
            }
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            stack.setItemMeta(meta);
        }
        return stack;
    }

    protected void updateTitle(@NotNull Player player, @NotNull String title) {
        this.inventory = this.createInventory(title);
        this.closeAndOpen((HumanEntity)player, this.inventory);
    }

    public void setEnchantedOptionItemStack(int index, Material material, TranslationKey key, boolean value) {
        ItemStack stack = new ItemStack(material, 1);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            Bukkit.getItemFactory().getItemMeta(material);
        }
        if (meta != null) {
            meta.setDisplayName(Translator.get(key) + ": " + (value ? Translator.get(TranslationKey.ENABLED) : Translator.get(TranslationKey.DISABLED)));
            stack.setItemMeta(meta);
        }
        this.toggleOption(stack, value);
        this.inventory.setItem(index, stack);
    }

    @NotNull
    protected ItemStack toggleOption(@NotNull ItemStack stack, @Nullable Boolean toggle) {
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(stack.getType());
        }
        if (meta != null) {
            String name = meta.getDisplayName();
            int pos = name.lastIndexOf(58);
            if (pos != -1) {
                name = name.substring(0, pos);
            }
            if (meta.hasEnchants() && (toggle == null || !toggle.booleanValue())) {
                meta.removeEnchant(Enchantment.INFINITY);
                meta.setDisplayName(name + ": " + Translator.get(TranslationKey.DISABLED));
            } else if (!meta.hasEnchants() && (toggle == null || toggle.booleanValue())) {
                meta.addEnchant(Enchantment.INFINITY, 1, true);
                meta.setDisplayName(name + ": " + Translator.get(TranslationKey.ENABLED));
            }
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            stack.setItemMeta(meta);
        }
        return stack;
    }
}

