/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.FriendManageInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.nbt.BlockAccessFlag;
import de.sean.blockprot.bukkit.nbt.FriendHandler;
import de.sean.blockprot.bukkit.nbt.FriendSupportingHandler;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTCompound;
import de.sean.blockprot.bukkit.squirrelid.Profile;
import de.sean.blockprot.nbt.FriendModifyAction;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FriendDetailInventory
extends BlockProtInventory {
    @NotNull
    private static final List<EnumSet<BlockAccessFlag>> accessFlagCombinations = Arrays.asList(EnumSet.of(BlockAccessFlag.READ), EnumSet.of(BlockAccessFlag.READ, BlockAccessFlag.WRITE), EnumSet.of(BlockAccessFlag.READ, BlockAccessFlag.WRITE, BlockAccessFlag.MANAGER));
    @Nullable
    private EnumSet<BlockAccessFlag> curFlags = EnumSet.noneOf(BlockAccessFlag.class);
    @Nullable
    private FriendHandler playerHandler = null;

    @Override
    public int getSize() {
        return 9;
    }

    @Override
    @NotNull
    public String getTranslatedInventoryName() {
        return Translator.get(TranslationKey.INVENTORIES__FRIENDS__EDIT);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        switch (item.getType()) {
            case BLACK_STAINED_GLASS_PANE: {
                this.closeAndOpen((HumanEntity)player, new FriendManageInventory().fill(player));
                break;
            }
            case RED_STAINED_GLASS_PANE: {
                UUID friend = state.currentFriend;
                assert (friend != null);
                this.modifyFriendsForAction(player, friend, FriendModifyAction.REMOVE_FRIEND);
                this.playerHandler = null;
                this.closeAndOpen((HumanEntity)player, new FriendManageInventory().fill(player));
                break;
            }
            case ENDER_EYE: {
                int curIndex;
                if (this.playerHandler == null || this.curFlags == null) break;
                for (curIndex = 0; curIndex < accessFlagCombinations.size() && !this.curFlags.equals(accessFlagCombinations.get(curIndex)); ++curIndex) {
                }
                curIndex = curIndex + 1 >= accessFlagCombinations.size() ? 0 : ++curIndex;
                this.curFlags = accessFlagCombinations.get(curIndex);
                assert (this.curFlags != null);
                this.setItemStack(2, Material.ENDER_EYE, BlockAccessFlag.toBaseString(), BlockAccessFlag.accumulateAccessFlagLore(this.curFlags));
                break;
            }
            case PLAYER_HEAD: {
                break;
            }
            default: {
                this.closeAndOpen((HumanEntity)player, null);
            }
        }
        event.setCancelled(true);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
        if (this.playerHandler != null && this.curFlags != null) {
            this.playerHandler.setAccessFlags(this.curFlags);
        }
    }

    @Nullable
    public Inventory fill(@NotNull Player player) {
        InventoryState state = InventoryState.get(player.getUniqueId());
        if (state == null) {
            return this.inventory;
        }
        UUID uuid = state.currentFriend;
        if (uuid == null) {
            return this.inventory;
        }
        if (!uuid.equals(FriendSupportingHandler.publicUuid)) {
            try {
                Profile profile = BlockProt.getProfileService().findByUuid(uuid);
                assert (profile != null);
                this.setPlayerSkull(0, Bukkit.getServer().createPlayerProfile(profile.getUniqueId(), profile.getName()));
            }
            catch (Exception e) {
                BlockProt.getInstance().getLogger().warning("Failed to find PlayerProfile: " + String.valueOf(uuid));
            }
        } else {
            this.setItemStack(0, Material.PLAYER_HEAD, TranslationKey.INVENTORIES__FRIENDS__THE_PUBLIC, List.of(Translator.get(TranslationKey.INVENTORIES__FRIENDS__THE_PUBLIC_DESC)));
        }
        this.setItemStack(1, Material.RED_STAINED_GLASS_PANE, TranslationKey.INVENTORIES__FRIENDS__REMOVE);
        @Nullable FriendSupportingHandler<NBTCompound> handler = this.getFriendSupportingHandler(state.friendSearchState, player, state.getBlock());
        if (handler == null) {
            return null;
        }
        Optional<FriendHandler> friendHandler = handler.getFriend(uuid.toString());
        if (friendHandler.isEmpty()) {
            BlockProt.getInstance().getLogger().warning("Tried to open a " + this.getClass().getSimpleName() + " with a unknown player.");
            return null;
        }
        this.playerHandler = friendHandler.get();
        this.curFlags = this.playerHandler.getAccessFlags();
        this.setItemStack(2, Material.ENDER_EYE, BlockAccessFlag.toBaseString(), BlockAccessFlag.accumulateAccessFlagLore(this.curFlags));
        this.setBackButton();
        return this.inventory;
    }
}

