/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.inventories.BlockLockInventory;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.FriendDetailInventory;
import de.sean.blockprot.bukkit.inventories.FriendSearchHistoryInventory;
import de.sean.blockprot.bukkit.inventories.FriendSearchInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.inventories.UserSettingsInventory;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import de.sean.blockprot.bukkit.nbt.FriendHandler;
import de.sean.blockprot.bukkit.nbt.FriendSupportingHandler;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTCompound;
import de.sean.blockprot.bukkit.squirrelid.Profile;
import de.sean.blockprot.nbt.LockReturnValue;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FriendManageInventory
extends BlockProtInventory {
    private final int maxSkulls = this.getSize() - 9;

    @Override
    public int getSize() {
        return 54;
    }

    @Override
    @NotNull
    public String getTranslatedInventoryName() {
        return Translator.get(TranslationKey.INVENTORIES__FRIENDS__MANAGE);
    }

    public void exitModifyInventory(@NotNull Player player, @NotNull InventoryState state) {
        Inventory newInventory;
        switch (state.friendSearchState) {
            case FRIEND_SEARCH: {
                if (state.getBlock() == null) {
                    return;
                }
                BlockNBTHandler handler = this.getNbtHandlerOrNull(state.getBlock());
                if (handler == null) {
                    newInventory = null;
                    break;
                }
                newInventory = new BlockLockInventory().fill(player, state.getBlock().getState().getType(), handler);
                break;
            }
            case DEFAULT_FRIEND_SEARCH: {
                newInventory = new UserSettingsInventory().fill(player);
                break;
            }
            default: {
                return;
            }
        }
        this.closeAndOpen((HumanEntity)player, newInventory);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        switch (item.getType()) {
            case BLACK_STAINED_GLASS_PANE: {
                state.currentPageIndex = 0;
                this.exitModifyInventory(player, state);
                break;
            }
            case CYAN_STAINED_GLASS_PANE: {
                if (state.currentPageIndex < 1) break;
                --state.currentPageIndex;
                this.closeAndOpen((HumanEntity)player, this.fill(player));
                break;
            }
            case BLUE_STAINED_GLASS_PANE: {
                ItemStack lastFriendInInventory = event.getInventory().getItem(this.maxSkulls - 1);
                if (lastFriendInInventory == null || lastFriendInInventory.getAmount() == 0) break;
                ++state.currentPageIndex;
                this.closeAndOpen((HumanEntity)player, this.fill(player));
                break;
            }
            case SKELETON_SKULL: 
            case PLAYER_HEAD: {
                int index = this.findItemIndex(item);
                if (index < 0 || index >= state.friendResultCache.size()) break;
                state.currentFriend = state.friendResultCache.get(index);
                Inventory inv = new FriendDetailInventory().fill(player);
                this.closeAndOpen((HumanEntity)player, inv);
                break;
            }
            case MAP: {
                FriendSearchInventory.openAnvilInventory(player);
                break;
            }
            case BOOK: {
                this.closeAndOpen((HumanEntity)player, new FriendSearchHistoryInventory().fill(player));
                break;
            }
            case WITHER_SKELETON_SKULL: {
                this.applyChanges(player, handler -> {
                    handler.addEveryoneAsFriend();
                    return new LockReturnValue(true, null);
                }, FriendSupportingHandler::addEveryoneAsFriend);
                this.fill(player);
                break;
            }
            default: {
                this.closeAndOpen((HumanEntity)player, null);
            }
        }
        event.setCancelled(true);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
    }

    @Nullable
    public Inventory fill(@NotNull Player player) {
        InventoryState state = InventoryState.get(player.getUniqueId());
        if (state == null) {
            return this.inventory;
        }
        @Nullable FriendSupportingHandler<NBTCompound> handler = this.getFriendSupportingHandler(state.friendSearchState, player, state.getBlock());
        if (handler == null) {
            return null;
        }
        List<FriendHandler> friends = handler.getFriends();
        state.friendResultCache.clear();
        this.inventory.clear();
        boolean hasAddedPublic = false;
        for (FriendHandler friend : friends) {
            if (!friend.doesRepresentPublic()) continue;
            hasAddedPublic = true;
        }
        int pageOffset = this.maxSkulls * state.currentPageIndex;
        for (int i = 0; i < Math.min(friends.size() - pageOffset, this.maxSkulls); ++i) {
            String uuid = friends.get(pageOffset + i).getName();
            if (friends.get(pageOffset + i).doesRepresentPublic()) {
                this.setItemStack(i, Material.PLAYER_HEAD, TranslationKey.INVENTORIES__FRIENDS__THE_PUBLIC, List.of(Translator.get(TranslationKey.INVENTORIES__FRIENDS__THE_PUBLIC_DESC)));
            } else {
                this.setItemStack(i, Material.SKELETON_SKULL, uuid);
            }
            state.friendResultCache.add(UUID.fromString(uuid));
        }
        this.setItemStack(this.maxSkulls, Material.CYAN_STAINED_GLASS_PANE, TranslationKey.INVENTORIES__LAST_PAGE);
        this.setItemStack(this.maxSkulls + 1, Material.BLUE_STAINED_GLASS_PANE, TranslationKey.INVENTORIES__NEXT_PAGE);
        if (!hasAddedPublic) {
            this.setItemStack(this.getSize() - 4, Material.WITHER_SKELETON_SKULL, TranslationKey.INVENTORIES__FRIENDS__MAKE_PUBLIC);
        }
        this.setItemStack(this.getSize() - 3, Material.BOOK, TranslationKey.INVENTORIES__FRIENDS__SEARCH_HISTORY);
        this.setItemStack(this.getSize() - 2, Material.MAP, TranslationKey.INVENTORIES__FRIENDS__SEARCH);
        this.setBackButton();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BlockProt.getInstance(), () -> {
            try {
                ImmutableList<Profile> profiles = BlockProt.getProfileService().findAllByUuid(state.friendResultCache);
                for (int i = 0; i < Math.min(this.maxSkulls, profiles.size()); ++i) {
                    Profile profile = (Profile)profiles.get(i);
                    int index = Iterables.indexOf(state.friendResultCache, f -> f.equals(profile.getUniqueId()));
                    if (profile.getUniqueId().equals(FriendSupportingHandler.publicUuid)) continue;
                    this.setPlayerSkull(index, Bukkit.getServer().createPlayerProfile(profile.getUniqueId(), profile.getName()));
                }
            }
            catch (Exception e) {
                BlockProt.getInstance().getLogger().warning("Failed to update PlayerProfile: " + e.getMessage());
            }
        });
        return this.inventory;
    }
}

