/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import com.google.common.collect.ImmutableList;
import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.FriendManageInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.nbt.PlayerSettingsHandler;
import de.sean.blockprot.bukkit.squirrelid.Profile;
import de.sean.blockprot.nbt.FriendModifyAction;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FriendSearchHistoryInventory
extends BlockProtInventory {
    private final int maxSkulls = this.getSize() - 2;

    @Override
    int getSize() {
        return 27;
    }

    @Override
    @NotNull
    String getTranslatedInventoryName() {
        return Translator.get(TranslationKey.INVENTORIES__FRIENDS__SEARCH_HISTORY);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        switch (item.getType()) {
            case BLACK_STAINED_GLASS_PANE: {
                this.closeAndOpen((HumanEntity)player, new FriendManageInventory().fill(player));
                break;
            }
            case PLAYER_HEAD: 
            case SKELETON_SKULL: {
                SkullMeta meta = (SkullMeta)item.getItemMeta();
                if (meta == null) break;
                UUID id = meta.getOwningPlayer().getUniqueId();
                this.modifyFriendsForAction(player, id, FriendModifyAction.ADD_FRIEND);
                this.closeAndOpen((HumanEntity)player, new FriendManageInventory().fill(player));
                break;
            }
            default: {
                this.closeAndOpen((HumanEntity)player, null);
            }
        }
        event.setCancelled(true);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
    }

    public Inventory fill(Player player) {
        InventoryState state = InventoryState.get(player.getUniqueId());
        PlayerSettingsHandler settingsHandler = new PlayerSettingsHandler(player);
        List<String> searchHistory = settingsHandler.getSearchHistory();
        state.friendResultCache.clear();
        int max = Math.min(searchHistory.size(), this.maxSkulls);
        for (int i = 0; i < max; ++i) {
            this.setItemStack(i, Material.SKELETON_SKULL, searchHistory.get(i));
            state.friendResultCache.add(UUID.fromString(searchHistory.get(i)));
        }
        this.setBackButton();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)BlockProt.getInstance(), () -> {
            try {
                ImmutableList<Profile> profiles = BlockProt.getProfileService().findAllByUuid(state.friendResultCache);
                for (int i = 0; i < Math.min(profiles.size(), this.maxSkulls); ++i) {
                    Profile profile = (Profile)profiles.get(i);
                    this.setPlayerSkull(i, Bukkit.getServer().createPlayerProfile(profile.getUniqueId(), profile.getName()));
                }
            }
            catch (Exception e) {
                BlockProt.getInstance().getLogger().warning("Failed to update PlayerProfile: " + e.getMessage());
            }
        });
        return this.inventory;
    }
}

