/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.integrations.PluginIntegration;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.FriendManageInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.nbt.PlayerSettingsHandler;
import de.sean.blockprot.bukkit.squirrelid.Profile;
import de.sean.blockprot.nbt.FriendModifyAction;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FriendSearchResultInventory
extends BlockProtInventory {
    final ConcurrentLinkedQueue<Profile> resultQueue = new ConcurrentLinkedQueue();
    private final int maxResults = this.getSize() - 1;
    BukkitTask loadTask = null;
    BukkitTask updateTask = null;

    @Override
    int getSize() {
        return 27;
    }

    @Override
    @NotNull
    String getTranslatedInventoryName() {
        return Translator.get(TranslationKey.INVENTORIES__FRIENDS__RESULT);
    }

    private int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    private int levenshteinDistance(@NotNull CharSequence a, @NotNull CharSequence b) {
        int i;
        if (a.isEmpty()) {
            return b.length();
        }
        if (b.isEmpty()) {
            return a.length();
        }
        int[] mem = new int[b.length()];
        for (i = 0; i < b.length(); ++i) {
            mem[i] = i;
        }
        for (i = 1; i < a.length(); ++i) {
            int[] cur = new int[b.length()];
            cur[0] = i;
            for (int j = 1; j < b.length(); ++j) {
                int d1 = mem[j] + 1;
                int d2 = cur[j - 1] + 1;
                int d3 = mem[j - 1];
                if (a.charAt(i - 1) != b.charAt(j - 1)) {
                    ++d3;
                }
                cur[j] = this.min(d1, d2, d3);
            }
            mem = cur;
        }
        return mem[b.length() - 1];
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        switch (item.getType()) {
            case BLACK_STAINED_GLASS_PANE: {
                this.closeAndOpen((HumanEntity)player, new FriendManageInventory().fill(player));
                break;
            }
            case PLAYER_HEAD: 
            case SKELETON_SKULL: {
                SkullMeta meta = (SkullMeta)item.getItemMeta();
                if (meta == null) break;
                UUID id = meta.getOwningPlayer().getUniqueId();
                this.modifyFriendsForAction(player, id, FriendModifyAction.ADD_FRIEND);
                this.closeAndOpen((HumanEntity)player, new FriendManageInventory().fill(player));
                PlayerSettingsHandler settingsHandler = new PlayerSettingsHandler(player);
                settingsHandler.addPlayerToSearchHistory(id);
                break;
            }
            default: {
                this.closeAndOpen((HumanEntity)player, null);
            }
        }
        event.setCancelled(true);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
        if (this.loadTask != null) {
            this.loadTask.cancel();
        }
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
    }

    private double compareStrings(String str1, String str2) {
        int longerLength;
        String longer = str1;
        String shorter = str2;
        if (str1.length() < str2.length()) {
            longer = str2;
            shorter = str1;
        }
        if ((longerLength = longer.length()) == 0) {
            return 1.0;
        }
        return (double)(longerLength - this.levenshteinDistance(longer, shorter)) / (double)longerLength;
    }

    @Nullable
    public Inventory fill(@NotNull Player player, String searchQuery) {
        InventoryState state = InventoryState.get(player.getUniqueId());
        if (state == null) {
            return this.inventory;
        }
        this.updateTask = Bukkit.getScheduler().runTaskTimer((Plugin)BlockProt.getInstance(), (Runnable)new ResultUpdateTask(state), 0L, 1L);
        this.loadTask = Bukkit.getScheduler().runTaskAsynchronously((Plugin)BlockProt.getInstance(), (Runnable)new AsyncResultLoadTask(state, player, searchQuery));
        for (int i = 0; i < this.maxResults; ++i) {
            this.setItemStack(i, Material.SKELETON_SKULL, "Loading...");
        }
        this.setBackButton();
        return this.inventory;
    }

    private class ResultUpdateTask
    implements Runnable {
        InventoryState state;
        int playersIndex = 0;

        ResultUpdateTask(InventoryState state) {
            this.state = state;
        }

        @Override
        public void run() {
            Profile profile;
            BukkitScheduler scheduler = Bukkit.getScheduler();
            if (!scheduler.isQueued(FriendSearchResultInventory.this.loadTask.getTaskId()) && !scheduler.isCurrentlyRunning(FriendSearchResultInventory.this.loadTask.getTaskId()) && FriendSearchResultInventory.this.resultQueue.isEmpty()) {
                if (this.playersIndex == 0) {
                    for (int i = 0; i < FriendSearchResultInventory.this.maxResults; ++i) {
                        FriendSearchResultInventory.this.inventory.clear(i);
                    }
                }
                FriendSearchResultInventory.this.loadTask.cancel();
                FriendSearchResultInventory.this.updateTask.cancel();
            }
            while ((profile = FriendSearchResultInventory.this.resultQueue.poll()) != null && this.playersIndex < FriendSearchResultInventory.this.maxResults) {
                if (this.playersIndex == 0) {
                    for (int i = 0; i < FriendSearchResultInventory.this.maxResults; ++i) {
                        FriendSearchResultInventory.this.inventory.clear(i);
                    }
                }
                this.state.friendResultCache.add(profile.getUniqueId());
                FriendSearchResultInventory.this.setPlayerSkull(this.playersIndex, Bukkit.getServer().createPlayerProfile(profile.getUniqueId(), profile.getName()));
                ++this.playersIndex;
            }
            if (this.playersIndex == FriendSearchResultInventory.this.maxResults) {
                FriendSearchResultInventory.this.loadTask.cancel();
                FriendSearchResultInventory.this.updateTask.cancel();
            }
        }
    }

    private class AsyncResultLoadTask
    implements Runnable {
        InventoryState state;
        Player player;
        String searchQuery;

        AsyncResultLoadTask(@NotNull InventoryState state, @NotNull Player player, String searchQuery) {
            this.state = state;
            this.player = player;
            this.searchQuery = searchQuery;
        }

        @Override
        public void run() {
            double minimumSimilarity = BlockProt.getDefaultConfig().getFriendSearchSimilarityPercentage();
            OfflinePlayer[] offlinePlayers = Bukkit.getOfflinePlayers();
            Stream<UUID> stream = Arrays.stream(offlinePlayers).map(OfflinePlayer::getUniqueId).filter(uuid -> uuid.version() == 3 || uuid.version() == 4 || uuid.version() == 0);
            try {
                Stream<Profile> filterStream = BlockProt.getProfileService().findAllByUuid(stream.toList()).stream().filter(Objects::nonNull).filter(p -> p.getName() != null && !p.getUniqueId().equals(this.player.getUniqueId())).map(p -> new ImmutablePair(p, (Object)FriendSearchResultInventory.this.compareStrings(p.getName(), this.searchQuery))).filter(p -> (Double)p.right >= minimumSimilarity).sorted((a, b) -> ((Double)b.right).compareTo((Double)a.right)).map(p -> (Profile)p.left);
                if (this.state.friendSearchState == InventoryState.FriendSearchState.FRIEND_SEARCH && this.state.getBlock() != null) {
                    filterStream = filterStream.filter(f -> PluginIntegration.filterFriendByUuidForAll(f.getUniqueId(), this.player, this.state.getBlock()));
                }
                filterStream.limit(FriendSearchResultInventory.this.maxResults).forEach(FriendSearchResultInventory.this.resultQueue::add);
            }
            catch (Exception e) {
                BlockProt.getInstance().getLogger().warning("Failed to search and filter players during friend search: " + e.getMessage());
            }
        }
    }
}

