/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import de.sean.blockprot.bukkit.events.BlockAccessMenuEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InventoryState {
    private static final HashMap<String, InventoryState> players = new HashMap();
    @NotNull
    public final ArrayList<UUID> friendResultCache = new ArrayList();
    @Nullable
    private final Block block;
    @NotNull
    public FriendSearchState friendSearchState = FriendSearchState.FRIEND_SEARCH;
    public int currentPageIndex = 0;
    @Nullable
    public UUID currentFriend = null;
    @NotNull
    public Set<BlockAccessMenuEvent.MenuPermission> menuPermissions = new HashSet<BlockAccessMenuEvent.MenuPermission>();

    public InventoryState(@Nullable Block block) {
        this.block = block;
    }

    public static void set(String player, InventoryState state) {
        players.put(player, state);
    }

    public static void set(UUID player, InventoryState state) {
        players.put(player.toString(), state);
    }

    public static InventoryState get(String player) {
        return players.get(player);
    }

    public static InventoryState get(UUID player) {
        return players.get(player.toString());
    }

    public static void remove(String player) {
        players.remove(player);
    }

    public static void remove(UUID player) {
        players.remove(player.toString());
    }

    @Nullable
    public Block getBlock() {
        return this.block;
    }

    public static enum FriendSearchState {
        FRIEND_SEARCH,
        DEFAULT_FRIEND_SEARCH;

    }
}

