/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.inventories.BlockLockInventory;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import de.sean.blockprot.bukkit.nbt.RedstoneSettingsHandler;
import de.sean.blockprot.nbt.LockReturnValue;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RedstoneSettingsInventory
extends BlockProtInventory {
    private boolean currentProtection;
    private boolean hopperProtection;
    private boolean pistonProtection;
    private static final int SETTINGS_COUNT = 3;

    @Override
    int getSize() {
        return 18;
    }

    @Override
    @NotNull
    String getTranslatedInventoryName() {
        return Translator.get(TranslationKey.INVENTORIES__REDSTONE__SETTINGS);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        switch (item.getType()) {
            case REDSTONE: {
                this.currentProtection = !this.currentProtection;
                this.inventory.setItem(0, this.toggleOption(item, null));
                break;
            }
            case HOPPER: {
                this.hopperProtection = !this.hopperProtection;
                this.inventory.setItem(1, this.toggleOption(item, null));
                break;
            }
            case PISTON: {
                this.pistonProtection = !this.pistonProtection;
                this.inventory.setItem(2, this.toggleOption(item, null));
                break;
            }
            case RED_STAINED_GLASS_PANE: {
                this.overrideAllSettings(false);
                break;
            }
            case GREEN_STAINED_GLASS_PANE: {
                this.overrideAllSettings(true);
                break;
            }
            default: {
                BlockNBTHandler handler = this.getNbtHandlerOrNull(state.getBlock());
                this.closeAndOpen((HumanEntity)player, handler == null ? null : new BlockLockInventory().fill(player, state.getBlock().getType(), handler));
            }
        }
        event.setCancelled(true);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
        if (state.friendSearchState == InventoryState.FriendSearchState.FRIEND_SEARCH && state.getBlock() != null) {
            this.applyChanges((Player)event.getPlayer(), handler -> {
                RedstoneSettingsHandler redstoneHandler = handler.getRedstoneHandler();
                redstoneHandler.setCurrentProtection(this.currentProtection);
                redstoneHandler.setHopperProtection(this.hopperProtection);
                redstoneHandler.setPistonProtection(this.pistonProtection);
                return new LockReturnValue(true, null);
            }, null);
        }
    }

    private void overrideAllSettings(boolean value) {
        this.currentProtection = value;
        this.pistonProtection = value;
        this.hopperProtection = value;
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack == null) continue;
            this.inventory.setItem(i, this.toggleOption(stack, value));
        }
    }

    public Inventory fill(@NotNull Player player, @NotNull InventoryState state) {
        if (state.getBlock() == null) {
            return this.inventory;
        }
        BlockNBTHandler nbtHandler = this.getNbtHandlerOrNull(state.getBlock());
        if (nbtHandler == null) {
            return this.inventory;
        }
        if (!nbtHandler.isOwner(player.getUniqueId().toString())) {
            return this.inventory;
        }
        RedstoneSettingsHandler redstoneHandler = nbtHandler.getRedstoneHandler();
        this.currentProtection = redstoneHandler.getCurrentProtection();
        this.pistonProtection = redstoneHandler.getPistonProtection();
        this.hopperProtection = redstoneHandler.getHopperProtection();
        this.setEnchantedOptionItemStack(0, Material.REDSTONE, TranslationKey.INVENTORIES__REDSTONE__REDSTONE_PROTECTION, this.currentProtection);
        this.setEnchantedOptionItemStack(1, Material.HOPPER, TranslationKey.INVENTORIES__REDSTONE__HOPPER_PROTECTION, this.hopperProtection);
        this.setEnchantedOptionItemStack(2, Material.PISTON, TranslationKey.INVENTORIES__REDSTONE__PISTON_PROTECTION, this.pistonProtection);
        this.setItemStack(15, Material.RED_STAINED_GLASS_PANE, TranslationKey.INVENTORIES__REDSTONE__DISABLE_ALL);
        this.setItemStack(16, Material.GREEN_STAINED_GLASS_PANE, TranslationKey.INVENTORIES__REDSTONE__ENABLE_ALL);
        this.setBackButton();
        return this.inventory;
    }
}

