/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.inventories.StatisticsInventory;
import de.sean.blockprot.bukkit.nbt.stats.BukkitListStatistic;
import de.sean.blockprot.nbt.stats.ListStatisticItem;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatisticListInventory
extends BlockProtInventory {
    private BukkitListStatistic<ListStatisticItem<?, Material>, ?> statistic;

    @Override
    int getSize() {
        return 54;
    }

    @Override
    @NotNull
    String getTranslatedInventoryName() {
        return Translator.get(TranslationKey.INVENTORIES__STATISTICS__STATISTICS);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        switch (item.getType()) {
            case CYAN_STAINED_GLASS_PANE: {
                if (state.currentPageIndex < 1) break;
                --state.currentPageIndex;
                this.closeAndOpen(event.getWhoClicked(), this.fill((Player)event.getWhoClicked(), null));
                break;
            }
            case BLUE_STAINED_GLASS_PANE: {
                ++state.currentPageIndex;
                this.closeAndOpen(event.getWhoClicked(), this.fill((Player)event.getWhoClicked(), null));
                break;
            }
            case BLACK_STAINED_GLASS_PANE: {
                this.closeAndOpen(event.getWhoClicked(), new StatisticsInventory().fill((Player)event.getWhoClicked()));
                break;
            }
        }
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
    }

    public Inventory fill(@NotNull Player player, @Nullable BukkitListStatistic<ListStatisticItem<?, Material>, ?> stat) throws RuntimeException {
        if (stat != null) {
            this.statistic = stat;
        }
        if (this.statistic == null) {
            throw new RuntimeException("No cached statistic available.");
        }
        List list = (List)this.statistic.get();
        InventoryState state = InventoryState.get(player.getUniqueId());
        if (state == null) {
            return this.inventory;
        }
        list = list.stream().filter(item -> BlockProt.getDefaultConfig().isLockable((Material)item.getItemType())).collect(Collectors.toList());
        int max = this.getSize() - 3;
        int offset = max * state.currentPageIndex;
        for (int i = 0; i < Math.min(list.size() - offset, max); ++i) {
            ListStatisticItem item2 = (ListStatisticItem)list.get(offset + i);
            this.setItemStack(i, (Material)item2.getItemType(), item2.getTitle());
        }
        if (list.size() - offset > max) {
            this.setItemStack(max, Material.CYAN_STAINED_GLASS_PANE, TranslationKey.INVENTORIES__LAST_PAGE);
            this.setItemStack(max + 1, Material.BLUE_STAINED_GLASS_PANE, TranslationKey.INVENTORIES__NEXT_PAGE);
        }
        this.setBackButton();
        return this.inventory;
    }
}

