/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.inventories.StatisticListInventory;
import de.sean.blockprot.bukkit.nbt.StatHandler;
import de.sean.blockprot.bukkit.nbt.stats.BlockCountStatistic;
import de.sean.blockprot.bukkit.nbt.stats.BukkitListStatistic;
import de.sean.blockprot.bukkit.nbt.stats.BukkitStatistic;
import de.sean.blockprot.bukkit.nbt.stats.PlayerBlocksStatistic;
import de.sean.blockprot.nbt.stats.StatisticOnClickAction;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class StatisticsInventory
extends BlockProtInventory {
    private final List<BukkitStatistic<?>> playerStatistics = new ArrayList<BukkitStatistic<?>>(){
        {
            this.add(new PlayerBlocksStatistic());
        }
    };
    private final List<BukkitStatistic<?>> serverStatistics = new ArrayList<BukkitStatistic<?>>(){
        {
            this.add(new BlockCountStatistic());
        }
    };

    @Override
    int getSize() {
        return 54;
    }

    @Override
    @NotNull
    String getTranslatedInventoryName() {
        return Translator.get(TranslationKey.INVENTORIES__STATISTICS__PLAYER_STATISTICS);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        switch (item.getType()) {
            case BLUE_STAINED_GLASS_PANE: {
                if (!(event.getWhoClicked() instanceof Player)) break;
                state.currentPageIndex = (int)((long)state.currentPageIndex ^ 1L);
                this.updateTitle((Player)event.getWhoClicked(), state.currentPageIndex == 0 ? Translator.get(TranslationKey.INVENTORIES__STATISTICS__PLAYER_STATISTICS) : Translator.get(TranslationKey.INVENTORIES__STATISTICS__GLOBAL_STATISTICS));
                this.fill((Player)event.getWhoClicked());
                break;
            }
            case BLACK_STAINED_GLASS_PANE: {
                this.closeAndOpen(event.getWhoClicked(), null);
                break;
            }
            default: {
                BukkitStatistic<?> stat = state.currentPageIndex == 0 ? this.playerStatistics.get(event.getSlot()) : this.serverStatistics.get(event.getSlot());
                this.openStatInventory(stat, (Player)event.getWhoClicked());
            }
        }
        event.setCancelled(true);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
    }

    public void openStatInventory(@NotNull BukkitStatistic<?> stat, @NotNull Player player) {
        if (stat.getClickAction() == StatisticOnClickAction.NONE) {
            return;
        }
        if (player.getOpenInventory().getTopInventory().getHolder() instanceof StatisticListInventory) {
            return;
        }
        if (stat.getClickAction() == StatisticOnClickAction.LIST_MENU && stat instanceof BukkitListStatistic) {
            this.closeAndOpen((HumanEntity)player, new StatisticListInventory().fill(player, (BukkitListStatistic)stat));
        }
    }

    public Inventory fill(@NotNull Player player) {
        InventoryState state = InventoryState.get(player.getUniqueId());
        if (state == null || state.currentPageIndex >= 2) {
            return this.inventory;
        }
        List<BukkitStatistic<?>> statistics = state.currentPageIndex == 0 ? this.playerStatistics : this.serverStatistics;
        for (int i = 0; i < statistics.size() && i < this.getSize() - 2; ++i) {
            BukkitStatistic<?> stat = statistics.get(i);
            StatHandler.getStatistic(stat, player);
            this.setItemStack(i, stat.getItemType(), stat.getTitle());
        }
        this.setItemStack(this.getSize() - 2, Material.BLUE_STAINED_GLASS_PANE, state.currentPageIndex == 0 ? TranslationKey.INVENTORIES__STATISTICS__GLOBAL_STATISTICS : TranslationKey.INVENTORIES__STATISTICS__PLAYER_STATISTICS);
        this.setBackButton();
        return this.inventory;
    }
}

