/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.inventories;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.FriendManageInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.nbt.PlayerSettingsHandler;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class UserSettingsInventory
extends BlockProtInventory {
    @Override
    int getSize() {
        return 9;
    }

    @Override
    @NotNull
    String getTranslatedInventoryName() {
        return Translator.get(TranslationKey.INVENTORIES__USER_SETTINGS);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event, @NotNull InventoryState state) {
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        switch (item.getType()) {
            case BARRIER: {
                PlayerSettingsHandler settingsHandler = new PlayerSettingsHandler(player);
                settingsHandler.setLockOnPlace(!settingsHandler.getLockOnPlace());
                this.inventory.setItem(0, this.toggleOption(item, null));
                break;
            }
            case PLAYER_HEAD: {
                state.friendSearchState = InventoryState.FriendSearchState.DEFAULT_FRIEND_SEARCH;
                this.closeAndOpen((HumanEntity)player, new FriendManageInventory().fill(player));
                break;
            }
            default: {
                this.closeAndOpen((HumanEntity)player, null);
            }
        }
        event.setCancelled(true);
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event, @NotNull InventoryState state) {
    }

    public Inventory fill(Player player) {
        PlayerSettingsHandler settingsHandler = new PlayerSettingsHandler(player);
        boolean lockOnPlace = settingsHandler.getLockOnPlace();
        this.setEnchantedOptionItemStack(0, Material.BARRIER, TranslationKey.INVENTORIES__LOCK_ON_PLACE, lockOnPlace);
        if (!BlockProt.getDefaultConfig().isFriendFunctionalityDisabled()) {
            this.setItemStack(1, Material.PLAYER_HEAD, TranslationKey.INVENTORIES__FRIENDS__MANAGE);
        }
        this.setBackButton();
        return this.inventory;
    }
}

