/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.listeners;

import com.google.common.collect.Iterables;
import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.Permissions;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.events.BlockLockOnPlaceEvent;
import de.sean.blockprot.bukkit.integrations.PluginIntegration;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import de.sean.blockprot.bukkit.nbt.PlayerSettingsHandler;
import de.sean.blockprot.bukkit.nbt.StatHandler;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBT;
import de.sean.blockprot.bukkit.shaded.nbtapi.iface.ReadWriteNBT;
import de.sean.blockprot.bukkit.shaded.nbtapi.utils.MinecraftVersion;
import de.sean.blockprot.bukkit.util.BlockUtil;
import de.sean.blockprot.nbt.LockReturnValue;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BlockEventListener
implements Listener {
    private final BlockProt blockProt;

    public BlockEventListener(@NotNull BlockProt blockProt) {
        this.blockProt = blockProt;
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        if (BlockProt.getDefaultConfig().isWorldExcluded(event.getBlock().getWorld())) {
            return;
        }
        if (!BlockProt.getDefaultConfig().isLockable(event.getBlock().getType())) {
            return;
        }
        BlockNBTHandler handler = new BlockNBTHandler(event.getBlock());
        if (handler.isProtected()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (BlockProt.getDefaultConfig().isWorldExcluded(event.getBlock().getWorld())) {
            return;
        }
        if (!BlockProt.getDefaultConfig().isLockable(event.getBlock().getType())) {
            return;
        }
        BlockNBTHandler handler = new BlockNBTHandler(event.getBlock());
        if (!handler.isOwner(event.getPlayer().getUniqueId().toString()) && handler.isProtected()) {
            event.setCancelled(true);
        }
        if (!event.isCancelled()) {
            StatHandler.removeContainer(event.getPlayer(), event.getBlock());
            handler.clear();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onShulkerBoxBreak(BlockBreakEvent event) {
        if (BlockProt.getDefaultConfig().isWorldExcluded(event.getBlock().getWorld())) {
            return;
        }
        if (!BlockProt.getDefaultConfig().isLockableShulkerBox(event.getBlock().getType())) {
            return;
        }
        BlockNBTHandler handler = new BlockNBTHandler(event.getBlock());
        if (handler.isOwner(event.getPlayer().getUniqueId().toString()) && !event.isCancelled() && event.isDropItems() && event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            event.setDropItems(false);
            Collection itemsToDrop = event.getBlock().getDrops();
            if (itemsToDrop.isEmpty()) {
                return;
            }
            ItemStack item = (ItemStack)Iterables.getFirst((Iterable)itemsToDrop, null);
            if (item == null) {
                return;
            }
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
                ItemMeta meta = item.getItemMeta();
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                pdc.set(new NamespacedKey((Plugin)BlockProt.getInstance(), "shulker_data"), PersistentDataType.STRING, (Object)"Hi!");
                item.setItemMeta(meta);
                ReadWriteNBT nbt = NBT.itemStackToNBT(item);
                ReadWriteNBT entityData = nbt.getOrCreateCompound("components").getOrCreateCompound("minecraft:block_entity_data");
                entityData.setString("id", item.getType().getKey().toString());
                entityData.getOrCreateCompound("PublicBukkitValues").mergeCompound(handler.getNbtCopy());
                item = Objects.requireNonNull(NBT.itemStackFromNBT(nbt));
            } else {
                NBT.modify(item, readWriteItemNBT -> readWriteItemNBT.getOrCreateCompound("BlockEntityTag").getOrCreateCompound("PublicBukkitValues").mergeCompound(handler.getNbtCopy()));
            }
            event.getPlayer().getWorld().dropItemNaturally(event.getBlock().getLocation(), item);
            event.getBlock().setType(Material.AIR);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (BlockProt.getDefaultConfig().isWorldExcluded(event.getBlock().getWorld())) {
            return;
        }
        if (!event.getPlayer().hasPermission(Permissions.LOCK.key())) {
            return;
        }
        if (!BlockProt.getDefaultConfig().isLockable(event.getBlock().getType())) {
            return;
        }
        Block block = event.getBlockPlaced();
        String playerUuid = event.getPlayer().getUniqueId().toString();
        BlockNBTHandler handler = new BlockNBTHandler(block);
        if (handler.isNotProtected()) {
            PlayerSettingsHandler settingsHandler = new PlayerSettingsHandler(event.getPlayer());
            if (settingsHandler.getLockOnPlace()) {
                BlockLockOnPlaceEvent lockOnPlaceEvent = new BlockLockOnPlaceEvent(event.getBlock(), event.getPlayer());
                Bukkit.getPluginManager().callEvent((Event)lockOnPlaceEvent);
                if (!lockOnPlaceEvent.isCancelled()) {
                    LockReturnValue lock = handler.lockBlock(event.getPlayer());
                    if (!lock.success) {
                        event.setCancelled(true);
                        if (lock.reason != null) {
                            event.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)Translator.get(lock.reason)));
                        }
                        return;
                    }
                    settingsHandler.getFriendsStream().filter(fh -> PluginIntegration.filterFriendByUuidForAll(UUID.fromString(fh.getName()), event.getPlayer(), block)).forEach(handler::addFriend);
                }
                if (BlockProt.getDefaultConfig().disallowRedstoneOnPlace()) {
                    handler.getRedstoneHandler().setAll(false);
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.blockProt, () -> {
                if (block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST) {
                    BlockState doubleChestState = BlockUtil.getDoubleChest(block);
                    if (doubleChestState != null) {
                        BlockNBTHandler doubleChestHandler = new BlockNBTHandler(doubleChestState.getBlock());
                        if (doubleChestHandler.isNotProtected() || doubleChestHandler.isOwner(playerUuid)) {
                            handler.mergeHandler(doubleChestHandler);
                        } else {
                            event.getPlayer().getWorld().getBlockAt(block.getLocation()).breakNaturally();
                        }
                        StatHandler.removeContainer(event.getPlayer(), block);
                    }
                } else {
                    handler.setName(BlockUtil.getHumanReadableBlockName(block.getType()));
                    handler.applyToOtherContainer();
                }
            }, 1L);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPhysics(@NotNull BlockPhysicsEvent event) {
        BlockNBTHandler handler;
        if (event.getChangedType().toString().contains("ANVIL") && BlockProt.getDefaultConfig().isLockableBlock(event.getChangedType()) && (handler = new BlockNBTHandler(event.getBlock())).isProtected()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSignChanged(@NotNull SignChangeEvent event) {
        BlockNBTHandler handler;
        if (BlockProt.getDefaultConfig().isLockableBlock(event.getBlock().getType()) && (handler = new BlockNBTHandler(event.getBlock())).isProtected() && !handler.isOwner(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }
}

