/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.listeners;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Minecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Nullable;

public class HopperEventListener
implements Listener {
    @EventHandler
    public void onItemMove(InventoryMoveItemEvent event) {
        BlockNBTHandler sourceHandler;
        Block source;
        if (event.getSource().getHolder() == null) {
            return;
        }
        if (BlockProt.getDefaultConfig().isWorldExcluded(event.getSource().getHolder())) {
            return;
        }
        if ((event.getDestination().getType() == InventoryType.HOPPER || event.getSource().getType() == InventoryType.HOPPER) && (source = this.getBlock(event.getSource().getHolder())) != null && BlockProt.getDefaultConfig().isLockable(source.getType()) && (sourceHandler = new BlockNBTHandler(source)).isProtected()) {
            InventoryHolder destinationHolder = event.getDestination().getHolder();
            if (destinationHolder instanceof Container || destinationHolder instanceof DoubleChest) {
                Block destination = this.getBlock(event.getDestination().getHolder());
                if (destination != null && BlockProt.getDefaultConfig().isLockable(destination.getType())) {
                    BlockNBTHandler destinationHandler = new BlockNBTHandler(destination);
                    if (destinationHandler.isProtected() && !destinationHandler.isOwner(sourceHandler.getOwner()) && sourceHandler.getRedstoneHandler().getHopperProtection()) {
                        event.setCancelled(true);
                    } else if (destinationHandler.isNotProtected() && sourceHandler.getRedstoneHandler().getHopperProtection()) {
                        event.setCancelled(true);
                    }
                } else if (sourceHandler.getRedstoneHandler().getHopperProtection()) {
                    event.setCancelled(true);
                }
            } else if (destinationHolder instanceof Minecart && sourceHandler.getRedstoneHandler().getHopperProtection()) {
                event.setCancelled(true);
            }
        }
    }

    @Nullable
    private Block getBlock(InventoryHolder holder) {
        if (holder instanceof Container) {
            return ((Container)holder).getBlock();
        }
        if (holder instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)holder;
            if (doubleChest.getWorld() == null) {
                return null;
            }
            return doubleChest.getWorld().getBlockAt(doubleChest.getLocation());
        }
        return null;
    }
}

