/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.listeners;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.BlockProtAPI;
import de.sean.blockprot.bukkit.Permissions;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.events.BlockAccessEvent;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import de.sean.blockprot.bukkit.nbt.FriendHandler;
import de.sean.blockprot.bukkit.nbt.PlayerSettingsHandler;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.type.Lectern;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class InteractEventListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerInteract(PlayerInteractEvent event) {
        if (event.getClass().getName().equals("Lme.TechsCode.InsaneShops.utilities.FakeEvent;")) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (BlockProt.getDefaultConfig().isWorldExcluded(event.getClickedBlock().getWorld())) {
            return;
        }
        if (!BlockProt.getDefaultConfig().isLockable(event.getClickedBlock().getState().getType())) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            BlockAccessEvent accessEvent = new BlockAccessEvent(event.getClickedBlock(), player);
            Bukkit.getPluginManager().callEvent((Event)accessEvent);
            if (accessEvent.isCancelled()) {
                event.setCancelled(true);
                this.sendMessage(player, Translator.get(TranslationKey.MESSAGES__NO_PERMISSION));
            } else {
                String message;
                Long timestamp;
                BlockNBTHandler handler = new BlockNBTHandler(event.getClickedBlock());
                if (!handler.canAccess(player.getUniqueId().toString()) && !player.hasPermission(Permissions.BYPASS.key())) {
                    event.setCancelled(true);
                    this.sendMessage(player, Translator.get(TranslationKey.MESSAGES__NO_PERMISSION));
                } else if (event.getClickedBlock().getType() == Material.LECTERN && !handler.isOwner(player.getUniqueId())) {
                    Optional<FriendHandler> friend;
                    Lectern lectern = (Lectern)event.getClickedBlock().getBlockData();
                    if (!(lectern.hasBook() || !(friend = handler.getFriend(player.getUniqueId().toString())).isEmpty() && friend.get().canWrite())) {
                        event.setCancelled(true);
                        this.sendMessage(player, Translator.get(TranslationKey.MESSAGES__NO_PERMISSION));
                    }
                } else if (!(new PlayerSettingsHandler(player).hasPlayerInteractedWithMenu() || (timestamp = LockHintMessageCooldown.getTimestamp(player)) != null && timestamp >= System.currentTimeMillis() - BlockProt.getDefaultConfig().getLockHintCooldown() * 1000L || (message = Translator.get(TranslationKey.MESSAGES__LOCK_HINT)).isEmpty())) {
                    LockHintMessageCooldown.setTimestamp(player);
                    String tooltip = Translator.get(TranslationKey.MESSAGES__HINT_HOVER_TEXT);
                    this.sendEventsMessage(player, message, ChatMessageType.CHAT, "/blockprot disablehints", tooltip.isEmpty() ? null : tooltip);
                }
            }
        } else {
            if (event.hasItem()) {
                return;
            }
            event.setCancelled(true);
            if (!player.hasPermission(Permissions.LOCK.key())) {
                this.sendMessage(player, Translator.get(TranslationKey.MESSAGES__NO_PERMISSION));
                return;
            }
            Inventory inv = BlockProtAPI.getInstance().getLockInventoryForBlock(event.getClickedBlock(), player);
            if (inv == null) {
                this.sendMessage(player, Translator.get(TranslationKey.MESSAGES__NO_PERMISSION));
            } else {
                new PlayerSettingsHandler(player).setHasPlayerInteractedWithMenu(true);
                player.openInventory(inv);
            }
        }
    }

    private void sendMessage(@NotNull Player player, @NotNull String component) {
        this.sendMessage(player, component, ChatMessageType.ACTION_BAR);
    }

    private void sendMessage(@NotNull Player player, @NotNull String component, @NotNull ChatMessageType type) {
        player.spigot().sendMessage(type, TextComponent.fromLegacyText((String)component));
    }

    private void sendEventsMessage(@NotNull Player player, @NotNull String component, @NotNull ChatMessageType type, @Nullable String command, @Nullable String tooltip) {
        TextComponent message = new TextComponent(component);
        if (command != null) {
            message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        }
        if (tooltip != null) {
            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(tooltip)}));
        }
        player.spigot().sendMessage(type, (BaseComponent)message);
    }

    private static class LockHintMessageCooldown {
        private static final HashMap<Player, Long> timestamps = new HashMap();

        private LockHintMessageCooldown() {
        }

        public static void setTimestamp(@NotNull Player player) {
            timestamps.put(player, System.currentTimeMillis());
        }

        @Nullable
        public static Long getTimestamp(@NotNull Player player) {
            return timestamps.get(player);
        }
    }
}

