/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.listeners;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.Permissions;
import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import de.sean.blockprot.bukkit.events.BlockAccessEvent;
import de.sean.blockprot.bukkit.inventories.BlockProtInventory;
import de.sean.blockprot.bukkit.inventories.InventoryState;
import de.sean.blockprot.bukkit.nbt.BlockNBTHandler;
import de.sean.blockprot.bukkit.nbt.FriendHandler;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class InventoryEventListener
implements Listener {
    @EventHandler
    public void onInventoryClick(@NotNull InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        InventoryState state = InventoryState.get(player.getUniqueId());
        if (state != null) {
            InventoryHolder holder = event.getInventory().getHolder();
            if (holder instanceof BlockProtInventory) {
                InventoryHolder inventoryHolder;
                Inventory clickedInventory = event.getClickedInventory();
                if (clickedInventory != null && (inventoryHolder = clickedInventory.getHolder()) instanceof BlockProtInventory) {
                    BlockProtInventory bpInventory = (BlockProtInventory)inventoryHolder;
                    bpInventory.onClick(event, state);
                } else {
                    event.setCancelled(true);
                }
            }
        } else {
            try {
                if (event.getInventory().getHolder() == null) {
                    return;
                }
                BlockInventoryHolder blockHolder = (BlockInventoryHolder)event.getInventory().getHolder();
                if (BlockProt.getDefaultConfig().isLockable(blockHolder.getBlock().getType())) {
                    BlockNBTHandler handler = new BlockNBTHandler(blockHolder.getBlock());
                    String playerUuid = player.getUniqueId().toString();
                    if (handler.isProtected() && !handler.isOwner(playerUuid)) {
                        Optional<FriendHandler> friend = handler.getFriend(playerUuid);
                        if (friend.isPresent()) {
                            if (!friend.get().canWrite()) {
                                event.setCancelled(true);
                            } else if (!friend.get().canRead()) {
                                event.setCancelled(true);
                                player.closeInventory();
                            }
                        } else {
                            player.closeInventory();
                            event.setCancelled(true);
                        }
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void onLecternClick(@NotNull PlayerTakeLecternBookEvent event) {
        BlockNBTHandler handler = new BlockNBTHandler(event.getLectern().getBlock());
        UUID uuid = event.getPlayer().getUniqueId();
        if (handler.isProtected() && !handler.isOwner(uuid)) {
            Optional<FriendHandler> friend = handler.getFriend(uuid.toString());
            if (friend.isPresent()) {
                if (!friend.get().canWrite()) {
                    event.setCancelled(true);
                } else if (!friend.get().canRead()) {
                    event.setCancelled(true);
                    event.getPlayer().closeInventory();
                }
            } else {
                event.setCancelled(true);
                event.getPlayer().closeInventory();
            }
        }
    }

    @EventHandler
    public void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        InventoryState state = InventoryState.get(player.getUniqueId());
        if (state == null) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof BlockProtInventory) {
            ((BlockProtInventory)holder).onClose(event, state);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        HumanEntity state2;
        String playerUuid = event.getPlayer().getUniqueId().toString();
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof BlockProtInventory) {
            InventoryState state2 = InventoryState.get(playerUuid);
            if (state2 == null || state2.getBlock() == null) {
                return;
            }
            try {
                BlockNBTHandler handler = new BlockNBTHandler(state2.getBlock());
                Optional<FriendHandler> friend = handler.getFriend(playerUuid);
                if (!(handler.isNotProtected() || handler.isOwner(playerUuid) || friend.isPresent() && friend.get().isManager() || event.getPlayer().hasPermission(Permissions.ADMIN.key()) || event.getPlayer().hasPermission(Permissions.INFO.key()))) {
                    event.setCancelled(true);
                    this.sendMessage(event.getPlayer(), Translator.get(TranslationKey.MESSAGES__NO_PERMISSION));
                }
            }
            catch (RuntimeException handler) {}
        } else if ((holder instanceof Container || holder instanceof DoubleChest) && (state2 = event.getPlayer()) instanceof Player) {
            Block block;
            Player player = (Player)state2;
            if (holder instanceof Container) {
                Container container = (Container)holder;
                block = container.getBlock();
            } else {
                block = ((DoubleChest)holder).getLocation().getBlock();
            }
            if (BlockProt.getDefaultConfig().isLockable(block.getType())) {
                BlockAccessEvent accessEvent = new BlockAccessEvent(block, (Player)event.getPlayer());
                Bukkit.getPluginManager().callEvent((Event)accessEvent);
                if (accessEvent.isCancelled()) {
                    event.setCancelled(true);
                    this.sendMessage((HumanEntity)player, Translator.get(TranslationKey.MESSAGES__NO_PERMISSION));
                } else {
                    BlockNBTHandler handler = new BlockNBTHandler(block);
                    if (!(accessEvent.shouldBypassProtections() || handler.canAccess(player.getUniqueId().toString()) || player.hasPermission(Permissions.BYPASS.key()))) {
                        event.setCancelled(true);
                        this.sendMessage((HumanEntity)player, Translator.get(TranslationKey.MESSAGES__NO_PERMISSION));
                    }
                }
            }
        }
    }

    private void sendMessage(@NotNull HumanEntity player, @NotNull String component) {
        if (!(player instanceof Player)) {
            return;
        }
        ((Player)player).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)component));
    }
}

