/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.nbt;

import de.sean.blockprot.bukkit.TranslationKey;
import de.sean.blockprot.bukkit.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

public enum BlockAccessFlag {
    READ(TranslationKey.INVENTORIES__FRIENDS__PERMISSION__READ),
    WRITE(TranslationKey.INVENTORIES__FRIENDS__PERMISSION__WRITE),
    MANAGER(TranslationKey.INVENTORIES__FRIENDS__PERMISSION__MANAGER);

    @NotNull
    private final TranslationKey descriptionKey;

    private BlockAccessFlag(TranslationKey description) {
        this.descriptionKey = description;
    }

    public static EnumSet<BlockAccessFlag> parseFlags(int value) {
        EnumSet<BlockAccessFlag> flags = EnumSet.noneOf(BlockAccessFlag.class);
        BlockAccessFlag[] values = BlockAccessFlag.values();
        String digits = Integer.toString(value, 2);
        for (int i = digits.length() - 1; i >= 0; --i) {
            int k;
            char j = digits.charAt(i);
            if (j == '0' || (k = digits.length() - 1 - i) >= values.length) continue;
            flags.add(values[k]);
        }
        return flags;
    }

    public static String toBaseString() {
        return Translator.get(TranslationKey.INVENTORIES__FRIENDS__PERMISSIONS);
    }

    @NotNull
    public static List<String> accumulateAccessFlagLore(@NotNull EnumSet<BlockAccessFlag> flags) {
        if (flags.isEmpty()) {
            return Collections.singletonList("No access");
        }
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (BlockAccessFlag flag : flags) {
            builder.setLength(0);
            builder.append(ChatColor.RESET).append(ChatColor.YELLOW).append(flag.getDescription());
            ret.add(builder.toString());
        }
        return ret;
    }

    @NotNull
    public String getDescription() {
        return Translator.get(this.descriptionKey);
    }

    public int getFlag() {
        return 1 << this.ordinal();
    }
}

