/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.nbt;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.Permissions;
import de.sean.blockprot.bukkit.nbt.FriendHandler;
import de.sean.blockprot.bukkit.nbt.FriendSupportingHandler;
import de.sean.blockprot.bukkit.nbt.NBTHandler;
import de.sean.blockprot.bukkit.nbt.RedstoneSettingsHandler;
import de.sean.blockprot.bukkit.nbt.StatHandler;
import de.sean.blockprot.bukkit.nbt.stats.PlayerBlocksStatistic;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTBlock;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTCompound;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTContainer;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTTileEntity;
import de.sean.blockprot.bukkit.util.BlockUtil;
import de.sean.blockprot.nbt.FriendModifyAction;
import de.sean.blockprot.nbt.LockReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;

public final class BlockNBTHandler
extends FriendSupportingHandler<NBTCompound> {
    static final String OWNER_ATTRIBUTE = "splugin_owner";
    static final String LOCK_ATTRIBUTE = "blockprot_friends";
    static final String REDSTONE_ATTRIBUTE = "blockprot_redstone";
    static final String NAME_ATTRIBUTE = "blockprot_name";
    @NotNull
    public final Block block;

    public BlockNBTHandler(@NotNull Block block) throws RuntimeException {
        super(LOCK_ATTRIBUTE);
        this.block = block;
        if (BlockProt.getDefaultConfig().isLockableBlock(this.block.getType())) {
            this.container = new NBTBlock(block).getData();
        } else if (BlockProt.getDefaultConfig().isLockableTileEntity(this.block.getType())) {
            this.container = new NBTTileEntity(block.getState()).getPersistentDataContainer();
        } else {
            throw new RuntimeException("Given block " + String.valueOf(block.getType()) + " is not a lockable block/tile entity");
        }
    }

    @NotNull
    public String getOwner() {
        if (!this.container.hasTag(OWNER_ATTRIBUTE)) {
            return "";
        }
        return this.container.getString(OWNER_ATTRIBUTE);
    }

    public void setOwner(@NotNull String owner) {
        this.container.setString(OWNER_ATTRIBUTE, owner);
    }

    @NotNull
    public RedstoneSettingsHandler getRedstoneHandler() {
        return new RedstoneSettingsHandler(this.container.getOrCreateCompound(REDSTONE_ATTRIBUTE));
    }

    public boolean isNotProtected() {
        return this.getOwner().isEmpty() && this.getFriends().isEmpty();
    }

    public boolean isProtected() {
        return !this.isNotProtected();
    }

    public boolean isOwner(@NotNull String player) {
        return this.getOwner().equals(player);
    }

    public boolean isOwner(@NotNull UUID player) {
        return this.getOwner().equals(player.toString());
    }

    @Override
    @NotNull
    public String getName() {
        if (!this.container.hasTag(NAME_ATTRIBUTE)) {
            return this.block.getType().toString();
        }
        return this.container.getString(NAME_ATTRIBUTE);
    }

    public void setName(@NotNull String name) {
        this.container.setString(NAME_ATTRIBUTE, name);
    }

    public boolean canAccess(@NotNull String player) {
        Optional<FriendHandler> friend = this.getFriend(player);
        return this.isNotProtected() || this.getOwner().equals(player) || friend.isPresent() && friend.get().canRead();
    }

    public boolean canAccess(@NotNull FriendHandler friend) {
        return this.isNotProtected() || friend.canRead();
    }

    public boolean isNotNumeric(String string) {
        int i;
        char[] chars = string.toCharArray();
        int n = i = chars[0] == '-' ? 0 : -1;
        while (++i < string.length()) {
            char c = chars[i];
            if (Character.isDigit(c) || c == '.' || c == '-') continue;
            return true;
        }
        return false;
    }

    @NotNull
    public LockReturnValue lockBlock(@NotNull Player player) {
        String owner = this.getOwner();
        String playerUuid = player.getUniqueId().toString();
        if (owner.isEmpty()) {
            Integer maxBlockCount = BlockProt.getDefaultConfig().getMaxLockedBlockCount();
            if (maxBlockCount != null) {
                PlayerBlocksStatistic playerBlocksStatistic = new PlayerBlocksStatistic();
                StatHandler.getStatistic(playerBlocksStatistic, player);
                if (player.hasPermission("blockprot.lockmax")) {
                    ArrayList lists = new ArrayList(player.getEffectivePermissions());
                    Integer highestValueFound = null;
                    int i = -1;
                    while (++i < lists.size()) {
                        String foundValue;
                        PermissionAttachmentInfo permission = (PermissionAttachmentInfo)lists.get(i);
                        if (!permission.getPermission().toLowerCase().startsWith("blockprot.locklimit.") || !permission.getValue() || this.isNotNumeric(foundValue = permission.getPermission().toLowerCase().replace("blockprot.locklimit.", "")) || Integer.parseInt(foundValue) <= (highestValueFound == null ? 0 : highestValueFound)) continue;
                        highestValueFound = Integer.parseInt(foundValue);
                    }
                    if (highestValueFound != null && playerBlocksStatistic.get().size() >= highestValueFound) {
                        return new LockReturnValue(false, LockReturnValue.Reason.EXCEEDED_MAX_BLOCK_COUNT);
                    }
                } else if (playerBlocksStatistic.get().size() >= maxBlockCount) {
                    return new LockReturnValue(false, LockReturnValue.Reason.EXCEEDED_MAX_BLOCK_COUNT);
                }
            }
            owner = playerUuid;
            this.setOwner(owner);
            this.applyToOtherContainer();
            StatHandler.addBlock(player, this.block.getLocation());
            return new LockReturnValue(true, null);
        }
        if (owner.equals(playerUuid) || player.isOp() || player.hasPermission(Permissions.ADMIN.key())) {
            StatHandler.removeContainer(player, this.block);
            this.clear();
            this.applyToOtherContainer();
            return new LockReturnValue(true, null);
        }
        return new LockReturnValue(false, LockReturnValue.Reason.NO_PERMISSION);
    }

    @NotNull
    public LockReturnValue modifyFriends(@NotNull String player, @NotNull String friend, @NotNull FriendModifyAction action) {
        if (!this.isOwner(player)) {
            return new LockReturnValue(false, null);
        }
        switch (action) {
            case ADD_FRIEND: {
                if (this.containsFriend(friend)) {
                    return new LockReturnValue(false, null);
                }
                this.addFriend(friend);
                this.applyToOtherContainer();
                return new LockReturnValue(true, null);
            }
            case REMOVE_FRIEND: {
                if (this.containsFriend(friend)) {
                    this.removeFriend(friend);
                    this.applyToOtherContainer();
                    return new LockReturnValue(true, null);
                }
                return new LockReturnValue(false, null);
            }
        }
        return new LockReturnValue(false, null);
    }

    public void applyToOtherContainer() {
        this.applyToOtherContainer(handler -> true, handler -> {});
    }

    public void applyToOtherContainer(@NotNull Predicate<BlockNBTHandler> condition, @NotNull Consumer<BlockNBTHandler> orElse) {
        BlockState doubleChestState;
        if (BlockProt.getDefaultConfig().isLockableDoor(this.block.getType())) {
            Block otherDoor = BlockUtil.getOtherDoorHalf(this.block.getState());
            if (otherDoor == null) {
                return;
            }
            BlockNBTHandler otherDoorHandler = new BlockNBTHandler(otherDoor);
            if (condition.test(otherDoorHandler)) {
                otherDoorHandler.mergeHandler(this);
            } else {
                orElse.accept(otherDoorHandler);
            }
        } else if ((this.block.getType() == Material.CHEST || this.block.getType() == Material.TRAPPED_CHEST) && (doubleChestState = BlockUtil.getDoubleChest(this.block)) != null) {
            BlockNBTHandler doubleChestHandler = new BlockNBTHandler(doubleChestState.getBlock());
            if (condition.test(doubleChestHandler)) {
                doubleChestHandler.mergeHandler(this);
            } else {
                orElse.accept(doubleChestHandler);
            }
        }
    }

    public void clear() {
        this.setOwner("");
        this.setFriends(Collections.emptyList());
        this.getRedstoneHandler().reset();
    }

    @Override
    public void mergeHandler(@NotNull NBTHandler<?> handler) {
        if (!(handler instanceof BlockNBTHandler)) {
            return;
        }
        BlockNBTHandler blockNBTHandler = (BlockNBTHandler)handler;
        this.setOwner(blockNBTHandler.getOwner());
        this.setFriends(blockNBTHandler.getFriends());
        this.getRedstoneHandler().mergeHandler(blockNBTHandler.getRedstoneHandler());
        this.setName(handler.getName());
    }

    @Override
    public void pasteNbt(@NotNull NBTContainer container) {
        container.removeKey(OWNER_ATTRIBUTE);
        super.pasteNbt(container);
        this.applyToOtherContainer();
    }
}

