/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.nbt;

import de.sean.blockprot.bukkit.nbt.BlockAccessFlag;
import de.sean.blockprot.bukkit.nbt.FriendSupportingHandler;
import de.sean.blockprot.bukkit.nbt.NBTHandler;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTCompound;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public final class FriendHandler
extends NBTHandler<NBTCompound> {
    static final String ACCESS_FLAGS_ATTRIBUTE = "blockprot_access_flags";

    public FriendHandler(@NotNull NBTCompound compound) {
        this.container = compound;
    }

    @Override
    @NotNull
    public String getName() {
        String name = this.container.getName();
        return name == null ? "" : name;
    }

    public boolean doesRepresentPublic() {
        return this.getName().equals(FriendSupportingHandler.publicUuid.toString());
    }

    private int getAccessFlagsBitset() {
        if (!this.container.hasKey(ACCESS_FLAGS_ATTRIBUTE).booleanValue()) {
            return BlockAccessFlag.READ.getFlag() | BlockAccessFlag.WRITE.getFlag();
        }
        return this.container.getInteger(ACCESS_FLAGS_ATTRIBUTE);
    }

    private void setAccessFlagsBitset(int flagsBitset) {
        this.container.setInteger(ACCESS_FLAGS_ATTRIBUTE, flagsBitset);
    }

    @NotNull
    public EnumSet<BlockAccessFlag> getAccessFlags() {
        if (!this.container.hasKey(ACCESS_FLAGS_ATTRIBUTE).booleanValue()) {
            return EnumSet.of(BlockAccessFlag.READ, BlockAccessFlag.WRITE);
        }
        return BlockAccessFlag.parseFlags(this.container.getInteger(ACCESS_FLAGS_ATTRIBUTE));
    }

    public void setAccessFlags(@NotNull EnumSet<BlockAccessFlag> flags) {
        this.setAccessFlagsBitset(flags.stream().mapToInt(BlockAccessFlag::getFlag).sum());
    }

    public boolean canRead() {
        return this.getAccessFlags().contains((Object)BlockAccessFlag.READ);
    }

    public boolean canWrite() {
        return this.getAccessFlags().contains((Object)BlockAccessFlag.WRITE);
    }

    public boolean isManager() {
        return this.getAccessFlags().contains((Object)BlockAccessFlag.MANAGER);
    }

    @Override
    public void mergeHandler(@NotNull NBTHandler<?> handler) {
        if (handler instanceof FriendHandler) {
            this.setAccessFlagsBitset(((FriendHandler)handler).getAccessFlagsBitset());
        }
    }
}

