/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.nbt;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.nbt.FriendHandler;
import de.sean.blockprot.bukkit.nbt.NBTHandler;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTCompound;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class FriendSupportingHandler<T extends NBTCompound>
extends NBTHandler<T> {
    @NotNull
    private final String friendNbtKey;
    public static final UUID publicUuid = new UUID(-1L, -1L);

    public FriendSupportingHandler(@NotNull String friendNbtKey) {
        this.friendNbtKey = friendNbtKey;
    }

    private NBTCompound compound() {
        return this.container.getOrCreateCompound(this.friendNbtKey);
    }

    protected void preFriendReadCallback() {
    }

    public Stream<FriendHandler> getFriendsStream() {
        this.preFriendReadCallback();
        if (!this.container.hasTag(this.friendNbtKey)) {
            return Stream.empty();
        }
        if (BlockProt.getDefaultConfig().isFriendFunctionalityDisabled()) {
            return Stream.empty();
        }
        NBTCompound compound = this.container.getOrCreateCompound(this.friendNbtKey);
        return compound.getKeys().stream().map(k -> new FriendHandler(compound.getCompound((String)k))).sorted((a, b) -> a.doesRepresentPublic() ? -1 : 1);
    }

    public List<FriendHandler> getFriends() {
        return this.getFriendsStream().collect(Collectors.toList());
    }

    public void setFriends(@NotNull List<FriendHandler> friends) {
        this.container.removeKey(this.friendNbtKey);
        friends.forEach(this::addFriend);
    }

    @NotNull
    public Optional<FriendHandler> getFriend(@NotNull String id) {
        return this.getFriendsStream().filter(f -> f.getName().equals(id) || f.doesRepresentPublic()).min((a, b) -> a.doesRepresentPublic() ? 1 : -1);
    }

    public void addFriend(@NotNull String friend) {
        this.compound().addCompound(friend).setString("id", friend);
    }

    public void addFriend(@NotNull FriendHandler friend) {
        this.compound().addCompound(friend.getName()).mergeCompound(friend.container);
    }

    public void addEveryoneAsFriend() {
        this.addFriend(publicUuid.toString());
    }

    public void removeFriend(@NotNull String friend) {
        this.compound().removeKey(friend);
    }

    public boolean containsFriend(@NotNull String friendUuid) {
        return this.containsFriend(this.getFriendsStream(), friendUuid);
    }

    public boolean containsFriend(@NotNull Stream<FriendHandler> friends, @NotNull String friendUuid) {
        return friends.anyMatch(f -> f.getName().equals(friendUuid));
    }
}

