/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.nbt;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.nbt.FriendSupportingHandler;
import de.sean.blockprot.bukkit.nbt.NBTHandler;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTCompound;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTEntity;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTType;
import de.sean.blockprot.util.BlockProtUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class PlayerSettingsHandler
extends FriendSupportingHandler<NBTCompound> {
    static final String LOCK_ON_PLACE_ATTRIBUTE = "splugin_lock_on_place";
    static final String DEFAULT_FRIENDS_ATTRIBUTE = "blockprot_default_friends";
    static final String PLAYER_SEARCH_HISTORY = "blockprot_player_search_history";
    static final String PLAYER_HAS_INTERACTED_WITH_MENU = "blockprot_player_has_interacted_with_menu";
    private static final int MAX_HISTORY_SIZE = 25;
    public final Player player;

    public PlayerSettingsHandler(@NotNull Player player) {
        super(DEFAULT_FRIENDS_ATTRIBUTE);
        this.player = player;
        this.container = new NBTEntity((Entity)player).getPersistentDataContainer();
    }

    public boolean getLockOnPlace() {
        if (!this.container.hasKey(LOCK_ON_PLACE_ATTRIBUTE).booleanValue()) {
            return BlockProt.getDefaultConfig().lockOnPlaceByDefault();
        }
        return this.container.getBoolean(LOCK_ON_PLACE_ATTRIBUTE);
    }

    public void setLockOnPlace(boolean lockOnPlace) {
        this.container.setBoolean(LOCK_ON_PLACE_ATTRIBUTE, lockOnPlace);
    }

    @Override
    protected void preFriendReadCallback() {
        if (this.container.hasKey(DEFAULT_FRIENDS_ATTRIBUTE).booleanValue() && this.container.getType(DEFAULT_FRIENDS_ATTRIBUTE) == NBTType.NBTTagString) {
            List<String> originalList = BlockProtUtil.parseStringList(this.container.getString(DEFAULT_FRIENDS_ATTRIBUTE));
            this.container.removeKey(DEFAULT_FRIENDS_ATTRIBUTE);
            this.container.addCompound(DEFAULT_FRIENDS_ATTRIBUTE);
            originalList.forEach(this::addFriend);
        }
    }

    public List<String> getSearchHistory() {
        if (!this.container.hasTag(PLAYER_SEARCH_HISTORY)) {
            return new ArrayList<String>();
        }
        return BlockProtUtil.parseStringList(this.container.getString(PLAYER_SEARCH_HISTORY));
    }

    public void clearSearchHistory() {
        if (this.container.hasTag(PLAYER_SEARCH_HISTORY)) {
            this.container.removeKey(PLAYER_SEARCH_HISTORY);
        }
    }

    @Deprecated
    public void addPlayerToSearchHistory(@NotNull OfflinePlayer player) {
        this.addPlayerToSearchHistory(player.getUniqueId());
    }

    @Deprecated
    public void addPlayerToSearchHistory(@NotNull String playerUuid) {
        this.addPlayerToSearchHistory(UUID.fromString(playerUuid));
    }

    public void addPlayerToSearchHistory(@NotNull UUID player) {
        List<String> history = this.getSearchHistory();
        if (!history.contains(player.toString())) {
            if (history.size() == 25) {
                history.remove(0);
            }
            history.add(player.toString());
            this.container.setString(PLAYER_SEARCH_HISTORY, history.toString());
        }
    }

    public boolean hasPlayerInteractedWithMenu() {
        if (!this.container.hasKey(PLAYER_HAS_INTERACTED_WITH_MENU).booleanValue()) {
            return false;
        }
        return this.container.getBoolean(PLAYER_HAS_INTERACTED_WITH_MENU);
    }

    public void setHasPlayerInteractedWithMenu(boolean bool) {
        this.container.setBoolean(PLAYER_HAS_INTERACTED_WITH_MENU, bool);
    }

    @Override
    public void mergeHandler(@NotNull NBTHandler<?> handler) {
        if (!(handler instanceof PlayerSettingsHandler)) {
            return;
        }
        PlayerSettingsHandler playerSettingsHandler = (PlayerSettingsHandler)handler;
        this.setLockOnPlace(playerSettingsHandler.getLockOnPlace());
        this.container.setString(DEFAULT_FRIENDS_ATTRIBUTE, playerSettingsHandler.container.getString(DEFAULT_FRIENDS_ATTRIBUTE));
    }
}

