/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.nbt;

import de.sean.blockprot.bukkit.nbt.NBTHandler;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTCompound;
import org.jetbrains.annotations.NotNull;

public class RedstoneSettingsHandler
extends NBTHandler<NBTCompound> {
    public static final boolean DEFAULT_PROTECTION_VALUE = true;
    static final String CURRENT_PROTECTION_ATTRIBUTE = "current_protection";
    static final String PISTON_PROTECTION_ATTRIBUTE = "piston_protection";
    static final String HOPPER_PROTECTION_ATTRIBUTE = "hopper_protection";

    RedstoneSettingsHandler(@NotNull NBTCompound compound) {
        this.container = compound;
    }

    public boolean getCurrentProtection() {
        if (!this.container.hasKey(CURRENT_PROTECTION_ATTRIBUTE).booleanValue()) {
            return true;
        }
        return this.container.getBoolean(CURRENT_PROTECTION_ATTRIBUTE);
    }

    public void setCurrentProtection(boolean value) {
        this.container.setBoolean(CURRENT_PROTECTION_ATTRIBUTE, value);
    }

    public boolean getPistonProtection() {
        if (!this.container.hasKey(PISTON_PROTECTION_ATTRIBUTE).booleanValue()) {
            return true;
        }
        return this.container.getBoolean(PISTON_PROTECTION_ATTRIBUTE);
    }

    public void setPistonProtection(boolean value) {
        this.container.setBoolean(PISTON_PROTECTION_ATTRIBUTE, value);
    }

    public boolean getHopperProtection() {
        if (!this.container.hasKey(HOPPER_PROTECTION_ATTRIBUTE).booleanValue()) {
            return true;
        }
        return this.container.getBoolean(HOPPER_PROTECTION_ATTRIBUTE);
    }

    public void setHopperProtection(boolean value) {
        this.container.setBoolean(HOPPER_PROTECTION_ATTRIBUTE, value);
    }

    public void reset() {
        this.setAll(true);
    }

    public void setAll(boolean value) {
        this.setCurrentProtection(value);
        this.setPistonProtection(value);
        this.setHopperProtection(value);
    }

    @Override
    public void mergeHandler(@NotNull NBTHandler<?> handler) {
        if (!(handler instanceof RedstoneSettingsHandler)) {
            return;
        }
        RedstoneSettingsHandler redstoneHandler = (RedstoneSettingsHandler)handler;
        this.setCurrentProtection(redstoneHandler.getCurrentProtection());
        this.setPistonProtection(redstoneHandler.getPistonProtection());
        this.setHopperProtection(redstoneHandler.getHopperProtection());
    }
}

