/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.nbt;

import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.bukkit.nbt.NBTHandler;
import de.sean.blockprot.bukkit.nbt.stats.BlockCountStatistic;
import de.sean.blockprot.bukkit.nbt.stats.BukkitStatistic;
import de.sean.blockprot.bukkit.nbt.stats.PlayerBlocksStatistic;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTCompound;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTFile;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTType;
import de.sean.blockprot.bukkit.shaded.nbtapi.NbtApiException;
import de.sean.blockprot.bukkit.tasks.StatisticFileSaveTask;
import de.sean.blockprot.bukkit.util.BlockUtil;
import de.sean.blockprot.nbt.stats.StatisticType;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatHandler
extends NBTHandler<NBTCompound> {
    static final String STAT_FILE_NAME = "blockprot_stats.nbt";
    static final String STAT_BACKUP_FILE_NAME = "blockprot_stats.nbt_old";
    static final String PLAYER_SUB_KEY = "player_stats";
    static final String SERVER_SUB_KEY = "server_stats";
    @Nullable
    private static BukkitTask fileSaveTask;
    @Nullable
    private static File backupFile;
    @Nullable
    private static File temporarySwapFile;
    @Nullable
    private static NBTFile nbtFile;

    private StatHandler(@NotNull NBTCompound compound) {
        this.container = compound;
    }

    public void updateStatistic(@NotNull BukkitStatistic<?> statistic) {
        statistic.updateContainer(this.container);
    }

    public static void enable() {
        if (nbtFile != null) {
            return;
        }
        try {
            World world = (World)Bukkit.getServer().getWorlds().get(0);
            File baseFile = new File(world.getWorldFolder(), STAT_FILE_NAME);
            backupFile = new File(world.getWorldFolder(), STAT_BACKUP_FILE_NAME);
            temporarySwapFile = new File(world.getWorldFolder(), "blockprot_stats.nbt.tmp");
            if (!backupFile.exists() && !backupFile.createNewFile()) {
                throw new IOException("Failed to create backup statistic NBT file!");
            }
            try {
                nbtFile = new NBTFile(baseFile);
            }
            catch (NbtApiException e) {
                if (backupFile.exists()) {
                    try {
                        NBTFile backupNbtFile = new NBTFile(backupFile);
                        backupNbtFile.writeCompound(Files.newOutputStream(baseFile.toPath(), new OpenOption[0]));
                        nbtFile = new NBTFile(baseFile);
                    }
                    catch (NbtApiException be) {
                        BlockProt.getInstance().getLogger().warning("The statistics file and its backup are corrupted!");
                        backupFile.delete();
                        baseFile.delete();
                        nbtFile = new NBTFile(baseFile);
                    }
                }
                BlockProt.getInstance().getLogger().warning("The statistics file was corrupted and no backup file was found!");
                baseFile.delete();
                nbtFile = new NBTFile(baseFile);
            }
            fileSaveTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)BlockProt.getInstance(), (Runnable)new StatisticFileSaveTask(), 0L, 6000L);
        }
        catch (Throwable e) {
            BlockProt.getInstance().getLogger().warning("Failed to open BlockProt statistic file.");
        }
    }

    public static void saveFile() throws IOException {
        if (nbtFile != null && backupFile != null && temporarySwapFile != null) {
            OutputStream outputStream = Files.newOutputStream(backupFile.toPath(), new OpenOption[0]);
            nbtFile.writeCompound(outputStream);
            outputStream.close();
            try {
                if (backupFile.exists()) {
                    new NBTFile(backupFile);
                }
            }
            catch (NbtApiException e) {
                BlockProt.getInstance().getLogger().warning("Failed to re-read statistic NBT File!");
                backupFile.delete();
                return;
            }
            if (nbtFile.getFile().exists() && backupFile.exists()) {
                try {
                    Files.move(backupFile.toPath(), temporarySwapFile.toPath(), new CopyOption[0]);
                    Files.move(nbtFile.getFile().toPath(), backupFile.toPath(), new CopyOption[0]);
                    Files.move(temporarySwapFile.toPath(), nbtFile.getFile().toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new IOException("Failed to swap backup NBT file: " + e.getMessage());
                }
            } else if (backupFile.exists()) {
                if (!backupFile.renameTo(nbtFile.getFile())) {
                    throw new IOException("Failed to rename backup NBT file.");
                }
            } else {
                throw new IOException("NBT files have been deleted after usage!");
            }
        }
    }

    public static void disable() {
        if (fileSaveTask != null && !fileSaveTask.isCancelled()) {
            fileSaveTask.cancel();
        }
        try {
            StatHandler.saveFile();
        }
        catch (IOException e) {
            BlockProt.getInstance().getLogger().warning("Failed to save statistics file: " + e.getMessage());
        }
    }

    public static void addBlock(@NotNull Player player, @NotNull Location block) {
        BlockCountStatistic countStatistic = new BlockCountStatistic();
        PlayerBlocksStatistic containersStatistic = new PlayerBlocksStatistic();
        StatHandler.getStatistic(countStatistic);
        StatHandler.getStatistic(containersStatistic, player);
        countStatistic.increment();
        containersStatistic.add(block);
    }

    @Deprecated
    public static void removeContainer(@NotNull Player player, @NotNull Location block) {
        BlockCountStatistic countStatistic = new BlockCountStatistic();
        PlayerBlocksStatistic containersStatistic = new PlayerBlocksStatistic();
        StatHandler.getStatistic(countStatistic);
        StatHandler.getStatistic(containersStatistic, player);
        countStatistic.decrement();
        containersStatistic.remove(block);
    }

    public static void removeContainer(@NotNull Player player, @NotNull Block block) {
        Block otherDoor;
        if (BlockProt.getDefaultConfig().isLockableDoor(block.getType()) && (otherDoor = BlockUtil.getOtherDoorHalf(block.getState())) != null) {
            StatHandler.removeContainer(player, otherDoor.getLocation());
        }
        BlockCountStatistic countStatistic = new BlockCountStatistic();
        PlayerBlocksStatistic containersStatistic = new PlayerBlocksStatistic();
        StatHandler.getStatistic(countStatistic);
        StatHandler.getStatistic(containersStatistic, player);
        countStatistic.decrement();
        containersStatistic.remove(block.getLocation());
    }

    public static void getStatistic(@NotNull BukkitStatistic<?> statistic) {
        if (statistic.getType() == StatisticType.PLAYER) {
            throw new RuntimeException("StatHandler#getStatistic with player statistic called without player");
        }
        StatHandler.getStatistic(statistic, null);
    }

    public static void getStatistic(@NotNull BukkitStatistic<?> statistic, @Nullable Player player) {
        switch (statistic.getType()) {
            case ALL: 
            case PLAYER: {
                Object stats;
                if (player != null) {
                    stats = StatHandler.getStatsForPlayer(player.getUniqueId().toString());
                    ((Optional)stats).ifPresent(handler -> handler.updateStatistic(statistic));
                }
                if (statistic.getType() == StatisticType.PLAYER) break;
            }
            case GLOBAL: {
                Object stats = StatHandler.getServerStats();
                ((StatHandler)stats).updateStatistic(statistic);
            }
        }
    }

    @NotNull
    private static Stream<StatHandler> getPlayerStats() {
        if (nbtFile == null) {
            throw new RuntimeException("nbtFile was null.");
        }
        if (!nbtFile.hasKey(PLAYER_SUB_KEY).booleanValue()) {
            return Stream.empty();
        }
        NBTCompound list = nbtFile.getOrCreateCompound(PLAYER_SUB_KEY);
        return list.getKeys().stream().map(comp -> new StatHandler(list.getCompound((String)comp)));
    }

    @NotNull
    private static Optional<StatHandler> getStatsForPlayer(@NotNull String id) {
        Optional<StatHandler> ret = StatHandler.getPlayerStats().filter(p -> p.getName().equals(id)).findFirst();
        if (ret.isEmpty()) {
            return Optional.of(StatHandler.addStatsForPlayer(id));
        }
        return ret;
    }

    @NotNull
    private static StatHandler addStatsForPlayer(@NotNull String id) {
        if (nbtFile == null) {
            throw new RuntimeException("nbtFile was null.");
        }
        NBTCompound compound = nbtFile.getOrCreateCompound(PLAYER_SUB_KEY);
        compound.addCompound(id).setString("id", id);
        return new StatHandler(compound.getCompound(id));
    }

    @NotNull
    private static StatHandler getServerStats() {
        if (nbtFile == null) {
            throw new RuntimeException("nbtFile was null.");
        }
        if (nbtFile.hasKey(SERVER_SUB_KEY).booleanValue() && nbtFile.getType(SERVER_SUB_KEY) == NBTType.NBTTagCompound) {
            return new StatHandler(nbtFile.getCompound(SERVER_SUB_KEY));
        }
        return new StatHandler(nbtFile.addCompound(SERVER_SUB_KEY));
    }
}

