/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.nbt.stats;

import de.sean.blockprot.bukkit.nbt.stats.BukkitListStatistic;
import de.sean.blockprot.bukkit.nbt.stats.LocationListEntry;
import de.sean.blockprot.bukkit.shaded.nbtapi.NBTCompound;
import de.sean.blockprot.bukkit.shaded.nbtapi.iface.ReadWriteNBT;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public abstract class LocationListStatistic
extends BukkitListStatistic<LocationListEntry, Location> {
    @NotNull
    private Location parseLocationFromCompound(@NotNull ReadWriteNBT c) {
        return new Location(Bukkit.getWorld((String)c.getString("name")), c.getDouble("x").doubleValue(), c.getDouble("y").doubleValue(), c.getDouble("z").doubleValue());
    }

    private void writeLocationToCompound(@NotNull NBTCompound compound, @NotNull Location location) {
        compound.setString("name", Objects.requireNonNull(location.getWorld()).getName());
        compound.setDouble("x", location.getX());
        compound.setDouble("y", location.getY());
        compound.setDouble("z", location.getZ());
    }

    @NotNull
    public String toString() {
        return this.get().toString();
    }

    @Override
    @NotNull
    public List<LocationListEntry> get() {
        return this.getList().stream().map(this::parseLocationFromCompound).map(LocationListEntry::new).collect(Collectors.toList());
    }

    @Override
    public void set(@NotNull List<LocationListEntry> value) {
        this.container.removeKey(this.getKey());
        value.forEach(v -> this.add((Location)v.get()));
    }

    @Override
    public void add(@NotNull Location vector) {
        this.writeLocationToCompound(this.getList().addCompound(), vector);
    }

    @Override
    public void remove(@NotNull Location object) {
        this.getList().removeIf(c -> this.parseLocationFromCompound((ReadWriteNBT)c).equals((Object)object));
    }

    @Override
    public void remove(int index) {
        this.getList().remove(index);
    }
}

