/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.tasks;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import de.sean.blockprot.bukkit.BlockProt;
import de.sean.blockprot.util.SemanticVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateChecker
implements Runnable {
    @Nullable
    private static SemanticVersion latestVersion;
    @Nullable
    private final List<Player> recipients;
    @NotNull
    private final PluginDescriptionFile description;

    public UpdateChecker(@NotNull PluginDescriptionFile description) {
        this.description = description;
        this.recipients = null;
    }

    public UpdateChecker(@NotNull PluginDescriptionFile description, @Nullable List<Player> recipients) {
        this.recipients = recipients;
        this.description = description;
    }

    @Override
    public void run() {
        if (latestVersion != null) {
            this.sendMessage(new SemanticVersion(this.description.getVersion()), latestVersion);
        } else {
            try {
                SemanticVersion latestVersion;
                URL url = new URL("https://api.spigotmc.org/simple/0.2/index.php?action=getResource&id=87829");
                URLConnection connection = url.openConnection();
                connection.connect();
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                SpigotResource latest = (SpigotResource)new Gson().fromJson((Reader)reader, SpigotResource.class);
                UpdateChecker.latestVersion = latestVersion = latest.asSemantic();
                SemanticVersion ourVersion = new SemanticVersion(this.description.getVersion());
                this.sendMessage(ourVersion, latestVersion);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void sendMessage(SemanticVersion currentVersion, SemanticVersion latestVersion) {
        String message;
        boolean isOutdated = false;
        if (latestVersion.compareTo(currentVersion) > 0) {
            isOutdated = true;
            message = this.description.getName() + " is outdated. Current: " + String.valueOf(currentVersion) + " / Newest: " + String.valueOf(latestVersion);
        } else {
            message = latestVersion.compareTo(currentVersion) < 0 ? this.description.getName() + " is on Version " + String.valueOf(currentVersion) + ", even though latest is " + String.valueOf(latestVersion) : this.description.getName() + " is up to date. (" + String.valueOf(currentVersion) + ")";
        }
        if (this.recipients != null && !this.recipients.isEmpty()) {
            TextComponent component = new TextComponent(message);
            if (isOutdated) {
                component.setColor(ChatColor.YELLOW);
                component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.spigotmc.org/resources/blockprot.87829/"));
                component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Visit the website to update!")}));
            }
            for (Player player : this.recipients) {
                player.spigot().sendMessage((BaseComponent)component);
            }
        } else if (isOutdated) {
            BlockProt.getInstance().getLogger().warning(message);
        } else {
            BlockProt.getInstance().getLogger().info(message);
        }
    }

    public static final class SpigotResource {
        @SerializedName(value="current_version")
        String currentVersion;

        @Contract(value=" -> new")
        @NotNull
        public SemanticVersion asSemantic() {
            return new SemanticVersion(this.currentVersion);
        }
    }
}

