/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.bukkit.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Door;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockUtil {
    @Nullable
    public static BlockState getDoubleChest(@NotNull Block block) {
        Inventory chestInventory;
        DoubleChest doubleChest = null;
        BlockState chestState = block.getState();
        if (chestState instanceof Chest && (chestInventory = ((Chest)chestState).getInventory()) instanceof DoubleChestInventory) {
            doubleChest = ((DoubleChestInventory)chestInventory).getHolder();
        }
        if (doubleChest == null) {
            return null;
        }
        Location middle = doubleChest.getLocation();
        if ((double)block.getX() > middle.getX()) {
            middle.subtract(0.5, 0.0, 0.0);
        } else if ((double)block.getZ() > middle.getZ()) {
            middle.subtract(0.0, 0.0, 0.5);
        } else {
            middle.add(0.5, 0.0, 0.5);
        }
        return block.getWorld().getBlockAt(middle).getState();
    }

    @Nullable
    public static Block getOtherDoorHalf(@NotNull BlockState state) {
        try {
            Door door = (Door)state.getBlockData();
            Location other = state.getLocation().clone();
            if (door.getHalf() == Bisected.Half.TOP) {
                other.setY(other.getY() - 1.0);
            } else {
                other.setY(other.getY() + 1.0);
            }
            return state.getWorld().getBlockAt(other);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @NotNull
    public static String capitalizeFirstLetters(@NotNull String str) {
        String n = str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
        Matcher m = Pattern.compile("_[a-z]").matcher(n);
        while (m.find()) {
            n = n.substring(0, m.end() - 2) + n.substring(m.start(), m.end()).toUpperCase() + n.substring(m.end());
        }
        return n.replaceAll("_", " ");
    }

    @NotNull
    public static String getHumanReadableBlockName(@NotNull Material material) {
        return BlockUtil.capitalizeFirstLetters(material.name());
    }
}

