/*
 * Decompiled with CFR 0.152.
 */
package de.sean.blockprot.util;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SemanticVersion
implements Comparable<SemanticVersion> {
    private final String[] parts;
    private final String extension;

    public SemanticVersion(@NotNull String version) {
        String[] versionParts = version.split("-");
        this.parts = versionParts[0].split("\\.");
        this.extension = versionParts.length == 2 ? versionParts[1] : "";
    }

    @Override
    public int compareTo(@NotNull SemanticVersion other) {
        try {
            boolean preRelease = this.extension.contains("alpha") || this.extension.contains("beta");
            int length = Math.min(this.parts.length, other.parts.length);
            for (int i = 0; i < length; ++i) {
                int otherPart;
                int part = Integer.parseInt(this.parts[i]);
                if (part < (otherPart = Integer.parseInt(other.parts[i]))) {
                    return -1;
                }
                if (part <= otherPart || preRelease) continue;
                return 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SemanticVersion)) {
            return false;
        }
        return this.compareTo((SemanticVersion)obj) == 0;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.parts), this.extension);
    }

    public String toString() {
        return String.join((CharSequence)".", this.parts) + (String)(this.extension.isEmpty() ? "" : "-" + this.extension);
    }
}

