/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.easy_tweaker.network.packets;

import com.pyding.easy_tweaker.item.RecipeManager;
import com.pyding.easy_tweaker.util.EasyUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class GuiPacket {
    private UUID uuid;
    private int number;
    private String additional;

    public GuiPacket(UUID uuid, int number) {
        this.uuid = uuid;
        this.number = number;
        this.additional = "";
    }

    public GuiPacket(UUID uuid, int number, String additional) {
        this.uuid = uuid;
        this.number = number;
        this.additional = additional;
    }

    public static void encode(GuiPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.uuid);
        buf.writeInt(msg.number);
        buf.m_130070_(msg.additional);
    }

    public static GuiPacket decode(FriendlyByteBuf buf) {
        return new GuiPacket(buf.m_130259_(), buf.readInt(), buf.m_130277_());
    }

    public static boolean handle(GuiPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (msg.uuid.equals(player.m_20148_()) && player.m_20310_(2) && player.m_21205_().m_41720_() instanceof RecipeManager) {
                switch (msg.number) {
                    case 0: {
                        EasyUtil.writeRecipe(msg.additional, (Player)player);
                        break;
                    }
                    case 1: {
                        player.m_20194_().m_129892_().m_230957_(player.m_20203_(), "/reload");
                        break;
                    }
                    case 2: {
                        RecipeManager.openWorkbenchGUI((Player)player);
                        break;
                    }
                    case 3: {
                        RecipeManager.openFurnaceGUI((Player)player);
                        break;
                    }
                    case 4: {
                        RecipeManager.openSmithyGUI((Player)player);
                        break;
                    }
                    case 5: {
                        RecipeManager.openBrewingGUI((Player)player);
                        break;
                    }
                    case 6: {
                        RecipeManager.openBotaniaGUI((Player)player);
                    }
                }
            }
        });
        return true;
    }
}

