/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.easy_tweaker.util;

import com.pyding.easy_tweaker.EasyTweaker;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public class EasyUtil {
    public static String removeFurnace(String smeltedItem) {
        return "furnace.remove(" + EasyUtil.transform(smeltedItem) + ");";
    }

    public static String removeSmithy(String item) {
        return "smithing.remove(<tag:items:" + item.replaceFirst("^item:", "") + ">);";
    }

    public static String removeRecipeCraftingTable(String item) {
        return "craftingTable.removeByName(\"" + EasyUtil.cutPrefix(item) + "\");";
    }

    public static String removeBrew(String result, String reagent, String input) {
        return "brewing.removeRecipe(" + EasyUtil.transform(result) + ", " + EasyUtil.transform(reagent) + ", " + EasyUtil.transform(input) + ");";
    }

    public static String addShapeless(String result, String name, int count, List<String> list, String nbt) {
        int size = list.size();
        if (size < 9) {
            for (int i = 0; i < 9 - size; ++i) {
                list.add("item:minecraft:air");
            }
        }
        return "craftingTable.addShapeless(\"" + name.replaceAll(":", "_") + "\", " + EasyUtil.transform(result) + nbt + " * " + count + ", [" + EasyUtil.transform(list.get(0)) + ", " + EasyUtil.transform(list.get(1)) + ", " + EasyUtil.transform(list.get(2)) + ", " + EasyUtil.transform(list.get(3)) + ", " + EasyUtil.transform(list.get(4)) + ", " + EasyUtil.transform(list.get(5)) + ", " + EasyUtil.transform(list.get(6)) + ", " + EasyUtil.transform(list.get(7)) + ", " + EasyUtil.transform(list.get(8)) + "]);";
    }

    public static String addShaped(String result, String name, int count, List<String> list, String nbt) {
        int size = list.size();
        if (size < 9) {
            for (int i = 0; i < 9 - size; ++i) {
                list.add("item:minecraft:air");
            }
        }
        return "craftingTable.addShaped(\"" + name.replaceAll(":", "_") + "\", " + EasyUtil.transform(result) + nbt + " * " + count + ", [[" + EasyUtil.transform(list.get(0)) + ", " + EasyUtil.transform(list.get(1)) + ", " + EasyUtil.transform(list.get(2)) + "], [" + EasyUtil.transform(list.get(3)) + ", " + EasyUtil.transform(list.get(4)) + ", " + EasyUtil.transform(list.get(5)) + "], [" + EasyUtil.transform(list.get(6)) + ", " + EasyUtil.transform(list.get(7)) + ", " + EasyUtil.transform(list.get(8)) + "]]);";
    }

    public static String addFurnace(String result, String name, int count, String rawItem, float xp, int time, String nbt) {
        return "furnace.addRecipe(\"" + name.replaceAll(":", "_") + "\", " + EasyUtil.transform(result) + nbt + " * " + count + ", " + EasyUtil.transform(rawItem) + ", " + xp + ", " + time + ");";
    }

    public static String addBlastFurnace(String result, String name, int count, String rawItem, float xp, int time, String nbt) {
        return "blastFurnace.addRecipe(\"" + name.replaceAll(":", "_") + "\", " + EasyUtil.transform(result) + nbt + " * " + count + ", " + EasyUtil.transform(rawItem) + ", " + xp + ", " + time + ");";
    }

    public static String addSmithy(String result, String name, String base, String template, String material, String nbt, int quantity) {
        return "smithing.addTransformRecipe(\"" + name.replaceAll(":", "_") + "\", " + EasyUtil.transform(result) + nbt + " * " + quantity + ", " + EasyUtil.transform(template) + ", " + EasyUtil.transform(base) + ", " + EasyUtil.transform(material) + ");";
    }

    public static String addBrew(String result, String reagent, String input, String nbt) {
        return "brewing.addRecipe(" + EasyUtil.transform(result) + nbt + ", " + EasyUtil.transform(reagent) + ", " + EasyUtil.transform(input) + ");";
    }

    public static void writeRecipe(String recipe, Player player) {
        File[] zsFiles;
        if (!player.m_20310_(2)) {
            return;
        }
        String jarPath = EasyTweaker.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File jarFile = new File(jarPath);
        File modsDir = jarFile.getParentFile();
        if (modsDir == null || !modsDir.getName().equals("mods")) {
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)"Can't locate mods folder."));
            }
            return;
        }
        File mcRoot = modsDir.getParentFile();
        if (mcRoot == null) {
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)"Can't locate minecraft folder."));
            }
            return;
        }
        File scriptsDir = new File(mcRoot, "scripts");
        if (!scriptsDir.exists()) {
            scriptsDir.mkdirs();
        }
        File targetFile = (zsFiles = scriptsDir.listFiles((dir, nameFile) -> nameFile.endsWith(".zs"))) != null && zsFiles.length > 0 ? zsFiles[0] : new File(scriptsDir, "auto_generated.zs");
        try (FileWriter writer = new FileWriter(targetFile, true);){
            writer.write(recipe + System.lineSeparator());
            writer.flush();
            player.m_213846_((Component)Component.m_237113_((String)"Recipe added."));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String cutPrefix(String remove) {
        String target = "item:";
        int index = remove.indexOf(target);
        if (index != -1) {
            return remove.substring(index + target.length());
        }
        target = "block:";
        index = remove.indexOf(target);
        if (index != -1) {
            return remove.substring(index + target.length());
        }
        return remove;
    }

    public static String changePrefix(String item) {
        String target = "block:";
        int index = item.indexOf(target);
        if (index != -1) {
            item = item.replaceAll("block:", "item:");
        }
        return item;
    }

    public static String transform(String item) {
        if (item.contains("easyt_potion")) {
            return item.replaceAll("easyt_potion", "");
        }
        if (item.contains("potion")) {
            item = EasyUtil.transformPotion(item);
        }
        return "<" + EasyUtil.changePrefix(item) + ">";
    }

    public List<String> listAllItems(List<Slot> slots) {
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            Slot slot = slots.get(i);
            if (slot.m_6657_()) {
                items.add(slot.m_7993_().m_41778_().replaceAll("\\.", ":"));
                continue;
            }
            items.add("item:minecraft:air");
        }
        return items;
    }

    public static String transformPotion(String input) {
        String[] parts = input.split(":");
        if (parts.length == 5) {
            return "item:minecraft:potion";
        }
        return input;
    }
}

