/*
 * Decompiled with CFR 0.152.
 */
package fr.formiko.opitemsremover;

import fr.formiko.opitemsremover.OPItemsRemoverCommand;
import fr.formiko.opitemsremover.OPItemsRemoverListener;
import fr.formiko.opitemsremover.Remover;
import fr.formiko.opitemsremover.lib.co.aikar.commands.PaperCommandManager;
import fr.formiko.opitemsremover.lib.org.bstats.bukkit.Metrics;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class OPItemsRemoverPlugin
extends JavaPlugin {
    private Collection<Material> disabledItems;

    public static OPItemsRemoverPlugin getInstance() {
        return (OPItemsRemoverPlugin)JavaPlugin.getPlugin(OPItemsRemoverPlugin.class);
    }

    public void onEnable() {
        new Metrics((Plugin)this, 21798);
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new OPItemsRemoverListener(), (Plugin)this);
        PaperCommandManager manager = new PaperCommandManager((Plugin)this);
        manager.registerCommand(new OPItemsRemoverCommand());
    }

    public void reloadConfig() {
        super.reloadConfig();
        this.disabledItems = this.getConfig().getStringList("disabledItems").stream().map(String::toUpperCase).map(Material::valueOf).toList();
        for (Player player : this.getServer().getOnlinePlayers()) {
            Remover.removeOPItemsFromPlayer(player);
        }
    }

    public Collection<Material> getDisabledItems() {
        return this.disabledItems;
    }

    public static void log(String message) {
        if (OPItemsRemoverPlugin.getInstance().getConfig().getBoolean("debug", false)) {
            OPItemsRemoverPlugin.getInstance().getLogger().info(message);
        }
    }
}

