/*
 * Decompiled with CFR 0.152.
 */
package fr.formiko.opitemsremover.lib.co.aikar.commands;

import com.google.common.collect.SetMultimap;
import fr.formiko.opitemsremover.lib.co.aikar.commands.ACFUtil;
import fr.formiko.opitemsremover.lib.co.aikar.commands.CommandHelpFormatter;
import fr.formiko.opitemsremover.lib.co.aikar.commands.CommandIssuer;
import fr.formiko.opitemsremover.lib.co.aikar.commands.CommandManager;
import fr.formiko.opitemsremover.lib.co.aikar.commands.HelpEntry;
import fr.formiko.opitemsremover.lib.co.aikar.commands.MessageKeys;
import fr.formiko.opitemsremover.lib.co.aikar.commands.MessageType;
import fr.formiko.opitemsremover.lib.co.aikar.commands.RegisteredCommand;
import fr.formiko.opitemsremover.lib.co.aikar.commands.RootCommand;
import fr.formiko.opitemsremover.lib.co.aikar.commands.UnstableAPI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CommandHelp {
    private final CommandManager manager;
    private final CommandIssuer issuer;
    private final List<HelpEntry> helpEntries = new ArrayList<HelpEntry>();
    private final String commandName;
    final String commandPrefix;
    private int page = 1;
    private int perPage;
    List<String> search;
    private Set<HelpEntry> selectedEntry = new HashSet<HelpEntry>();
    private int totalResults;
    private int totalPages;
    private boolean lastPage;

    public CommandHelp(CommandManager manager, RootCommand rootCommand, CommandIssuer issuer) {
        RegisteredCommand defCommand;
        this.manager = manager;
        this.issuer = issuer;
        this.perPage = manager.defaultHelpPerPage;
        this.commandPrefix = manager.getCommandPrefix(issuer);
        this.commandName = rootCommand.getCommandName();
        SetMultimap<String, RegisteredCommand> subCommands = rootCommand.getSubCommands();
        HashSet<RegisteredCommand> seen = new HashSet<RegisteredCommand>();
        if (!rootCommand.getDefCommand().hasHelpCommand && (defCommand = rootCommand.getDefaultRegisteredCommand()) != null) {
            this.helpEntries.add(new HelpEntry(this, defCommand));
            seen.add(defCommand);
        }
        subCommands.entries().forEach(e -> {
            String key = (String)e.getKey();
            if (key.equals("__default") || key.equals("__catchunknown")) {
                return;
            }
            RegisteredCommand regCommand = (RegisteredCommand)e.getValue();
            if (!regCommand.isPrivate && regCommand.hasPermission(issuer) && !seen.contains(regCommand)) {
                this.helpEntries.add(new HelpEntry(this, regCommand));
                seen.add(regCommand);
            }
        });
    }

    @UnstableAPI
    protected void updateSearchScore(HelpEntry help) {
        if (this.search == null || this.search.isEmpty()) {
            help.setSearchScore(1);
            return;
        }
        RegisteredCommand cmd = help.getRegisteredCommand();
        int searchScore = 0;
        for (String word : this.search) {
            Pattern pattern = Pattern.compile(".*" + Pattern.quote(word) + ".*", 2);
            for (String subCmd : cmd.registeredSubcommands) {
                Pattern subCmdPattern = Pattern.compile(".*" + Pattern.quote(subCmd) + ".*", 2);
                if (pattern.matcher(subCmd).matches()) {
                    searchScore += 3;
                    continue;
                }
                if (!subCmdPattern.matcher(word).matches()) continue;
                ++searchScore;
            }
            if (pattern.matcher(help.getDescription()).matches()) {
                searchScore += 2;
            }
            if (pattern.matcher(help.getParameterSyntax(this.issuer)).matches()) {
                ++searchScore;
            }
            if (help.getSearchTags() == null || !pattern.matcher(help.getSearchTags()).matches()) continue;
            searchScore += 2;
        }
        help.setSearchScore(searchScore);
    }

    public CommandManager getManager() {
        return this.manager;
    }

    public boolean testExactMatch(String command) {
        this.selectedEntry.clear();
        for (HelpEntry helpEntry : this.helpEntries) {
            if (!helpEntry.getCommand().endsWith(" " + command)) continue;
            this.selectedEntry.add(helpEntry);
        }
        return !this.selectedEntry.isEmpty();
    }

    public void showHelp() {
        this.showHelp(this.issuer);
    }

    public void showHelp(CommandIssuer issuer) {
        CommandHelpFormatter formatter = this.manager.getHelpFormatter();
        if (!this.selectedEntry.isEmpty()) {
            HelpEntry first = ACFUtil.getFirstElement(this.selectedEntry);
            formatter.printDetailedHelpHeader(this, issuer, first);
            for (HelpEntry helpEntry2 : this.selectedEntry) {
                formatter.showDetailedHelp(this, helpEntry2);
            }
            formatter.printDetailedHelpFooter(this, issuer, first);
            return;
        }
        List<Object> helpEntries = this.getHelpEntries().stream().filter(HelpEntry::shouldShow).collect(Collectors.toList());
        Iterator<Object> results = helpEntries.stream().sorted(Comparator.comparingInt(helpEntry -> helpEntry.getSearchScore() * -1)).iterator();
        if (!results.hasNext()) {
            issuer.sendMessage(MessageType.ERROR, MessageKeys.NO_COMMAND_MATCHED_SEARCH, "{search}", ACFUtil.join(this.search, " "));
            helpEntries = this.getHelpEntries();
            results = helpEntries.iterator();
        }
        this.totalResults = helpEntries.size();
        int min = (this.page - 1) * this.perPage;
        int max = min + this.perPage;
        this.totalPages = (int)Math.ceil((float)this.totalResults / (float)this.perPage);
        int i = 0;
        if (min >= this.totalResults) {
            issuer.sendMessage(MessageType.HELP, MessageKeys.HELP_NO_RESULTS, new String[0]);
            return;
        }
        ArrayList<HelpEntry> printEntries = new ArrayList<HelpEntry>();
        while (results.hasNext()) {
            HelpEntry e = (HelpEntry)results.next();
            if (i >= max) break;
            if (i++ < min) continue;
            printEntries.add(e);
        }
        boolean bl = this.lastPage = max >= this.totalResults;
        if (this.search == null) {
            formatter.showAllResults(this, printEntries);
        } else {
            formatter.showSearchResults(this, printEntries);
        }
    }

    public List<HelpEntry> getHelpEntries() {
        return this.helpEntries;
    }

    public void setPerPage(int perPage) {
        this.perPage = perPage;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setPage(int page, int perPage) {
        this.setPage(page);
        this.setPerPage(perPage);
    }

    public void setSearch(List<String> search) {
        this.search = search;
        this.getHelpEntries().forEach(this::updateSearchScore);
    }

    public CommandIssuer getIssuer() {
        return this.issuer;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandPrefix() {
        return this.commandPrefix;
    }

    public int getPage() {
        return this.page;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public List<String> getSearch() {
        return this.search;
    }

    public Set<HelpEntry> getSelectedEntry() {
        return this.selectedEntry;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public boolean isOnlyPage() {
        return this.page == 1 && this.lastPage;
    }

    public boolean isLastPage() {
        return this.lastPage;
    }
}

