#version 150

#moj_import <minecraft:dynamictransforms.glsl>
#moj_import <minecraft:globals.glsl>
#moj_import <minecraft:projection.glsl>

in vec3 Position;
in vec2 UV0;
in vec4 Color;

uniform sampler2D Sampler0; // the texture being rendered

out vec2 texCoord0;// the coordinates of the uv   | both of these are sent to the fragment shader
out vec4 vertexColor;// the color of the vertex   |

vec2[] corners = vec2[](vec2(0, 0), vec2(0, 1), vec2(1, 1), vec2(1, 0)); // a corner value library


void main() {
    texCoord0 = UV0;
    vertexColor = Color;
    //====================== anything above was the original minecraft shader, it's just passing values to fragment shader

    //the id of the vertex starting from top left, it goes counter clockwise 0-1-2-3 ending on the top right
    int vertID = gl_VertexID % 4;
    //the cornering being actively rendered, by using the vertex id and taking the corner value from the library
    vec2 corner = corners[vertID];
    //the color 0-255 of the top left pixel of the image
    vec4 color = round(texture(Sampler0, vec2(0))*255);
    

    //grabbing the original position so we can edit it
    vec3 pos = Position;

    if(color.a == 1){ //checking if the texture has the correct alpha value in the corner

        pos.xy += 2*(corner-0.5)*14; //moving the vertices 14px outwards
        texCoord0 = corner;//changing the uv to be the full texture

    }

    //====================== the position renedring definition is below, it's only been changed do use our pos variable
    gl_Position = ProjMat * ModelViewMat * vec4(pos, 1.0);
}
