#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>
#moj_import <minecraft:globals.glsl>
#moj_import <minecraft:projection.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;

uniform sampler2D Sampler2;//texture
uniform sampler2D Sampler0;//lightmap

out float sphericalVertexDistance;
out float cylindricalVertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

vec2[] corners = vec2[](vec2(0, 0), vec2(0, 1), vec2(1, 1), vec2(1, 0));

void main() {
    

    int vertID = gl_VertexID % 4;
    vec2 corner = corners[vertID];
    vec4 color = round(texture(Sampler0, UV0-(0.001*corner))*255); 

    //note: text uses an atlas, the color variable changes,so this time add the same pixel to all the corners of the texture

    vec3 pos = Position;

    if(color.a == 1 && Color != vec4(1)){// normal check, and also checks if the color is NOT pure white (so a shadow) 

       pos.xy = vec2(0);
    }

    //notes: this means it will affect colored text, this can be circumvented later if you'd like
    //       vecs with only one value "vec2(0)", "vec4(1)" are the same as vec2(0,0) and vec4(1,1,1,1), the number on every value

    //===================================== Normal shader
    vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);
    gl_Position = ProjMat * ModelViewMat * vec4(pos, 1.0);

    sphericalVertexDistance = fog_spherical_distance(Position);
    cylindricalVertexDistance = fog_cylindrical_distance(Position);
    
    texCoord0 = UV0;
}
