/*
 * Decompiled with CFR 0.152.
 */
package me.Athar42.ap2cd;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import me.Athar42.ap2cd.command.AudioPlayer2CustomDiscsCommand;
import me.Athar42.ap2cd.listener.AutoConvertHeadPlay;
import me.Athar42.ap2cd.listener.AutoConvertJukeBox;
import me.Athar42.ap2cd.utils.AP2CDUtils;
import me.Athar42.ap2cd.utils.TypeChecker;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPI;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPIPaperConfig;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AudioPlayer2CustomDiscs
extends JavaPlugin {
    static AudioPlayer2CustomDiscs instance;
    @Nullable
    private Logger pluginLogger;
    private static Component[] helpMessage;
    private static final LegacyComponentSerializer LegacyComponentAmpersand;
    private static boolean debugMode;
    private static boolean automaticConvertMode;

    public void onLoad() {
        instance = this;
        CommandAPI.onLoad(((CommandAPIPaperConfig)new CommandAPIPaperConfig((LifecycleEventOwner)this).verboseOutput(true)).fallbackToLatestNMS(true));
    }

    public void onEnable() {
        this.pluginLogger = this.getLogger();
        CommandAPI.onEnable();
        new AudioPlayer2CustomDiscsCommand(this).register("audioplayer2customdiscs");
        this.saveDefaultConfig();
        debugMode = this.getConfig().getBoolean("debugMode", false);
        automaticConvertMode = this.getConfig().getBoolean("automaticConvert", false);
        String stgAutomaticConvertMode = automaticConvertMode ? "&aEnabled" : "&cDisabled";
        helpMessage = new Component[]{LegacyComponentAmpersand.deserialize("&8-[&6AudioPlayer2CustomDiscs v" + this.getPluginMeta().getVersion() + " - Help Page&8]-"), LegacyComponentAmpersand.deserialize("&8-[&6Automatic Conversion mode: " + stgAutomaticConvertMode + "&8]-"), LegacyComponentAmpersand.deserialize("&aAuthor&7: ").append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Athar42").color(TextColor.color((int)14263092))).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)"https://github.com/Athar42"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to open Athar42's GitHub page")))), LegacyComponentAmpersand.deserialize("&2Modrinth&7: ").append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"https://modrinth.com/project/uGyuzT6k").color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)"https://modrinth.com/project/uGyuzT6k"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to open AudioPlayer2CustomDiscs' Modrinth page")))), LegacyComponentAmpersand.deserialize("&fGit&0Hub&7: ").append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"https://github.com/Athar42/ap2cd").color((TextColor)NamedTextColor.BLUE)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl((String)"https://github.com/Athar42/ap2cd"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to open AudioPlayer2CustomDiscs' GitHub page"))))};
        if (automaticConvertMode) {
            this.getServer().getPluginManager().registerEvents((Listener)new AutoConvertJukeBox(), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new AutoConvertHeadPlay(), (Plugin)this);
            ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
            protocolManager.addPacketListener((PacketListener)new PacketAdapter(this, (Plugin)instance, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.USE_ITEM}){

                public void onPacketReceiving(PacketEvent event) {
                    NamespacedKey convertedKeyRetrieval;
                    ItemStack item;
                    if (event.getPlayer() == null) {
                        return;
                    }
                    Player player = event.getPlayer();
                    if (debugMode) {
                        player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-001 - INSIDE NEW PACKET EVENT."));
                    }
                    EnumWrappers.Hand hand = null;
                    try {
                        hand = (EnumWrappers.Hand)event.getPacket().getEnumModifier(EnumWrappers.Hand.class, 0).readSafely(0);
                    }
                    catch (Exception ignored) {
                        return;
                    }
                    if (hand == EnumWrappers.Hand.OFF_HAND) {
                        item = player.getInventory().getItemInOffHand();
                        if (debugMode) {
                            player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-002A - OFFHAND DETECTED."));
                        }
                    } else {
                        item = player.getInventory().getItemInMainHand();
                        if (debugMode) {
                            player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-002B - MAINHAND DETECTED."));
                        }
                    }
                    if (!TypeChecker.isGoatHornPlayer(player)) {
                        return;
                    }
                    ItemMeta meta = item.getItemMeta();
                    if (meta == null) {
                        return;
                    }
                    PersistentDataContainer data = meta.getPersistentDataContainer();
                    if (data.has(convertedKeyRetrieval = new NamespacedKey(this.plugin, "converted"), PersistentDataType.BOOLEAN) && Boolean.TRUE.equals(data.get(convertedKeyRetrieval, PersistentDataType.BOOLEAN))) {
                        if (debugMode) {
                            player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-003 - Already converted!"));
                        }
                        return;
                    }
                    EnumWrappers.Hand hand2 = hand;
                    Bukkit.getGlobalRegionScheduler().run(this.plugin, scheduledTask -> {
                        boolean mainOffHand;
                        ItemStack item2;
                        if (hand2 == EnumWrappers.Hand.OFF_HAND) {
                            item2 = player.getInventory().getItemInOffHand();
                            mainOffHand = false;
                            if (debugMode) {
                                player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-004A - OFFHAND DETECTED 2."));
                            }
                        } else {
                            item2 = player.getInventory().getItemInMainHand();
                            mainOffHand = true;
                            if (debugMode) {
                                player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-004B - MAINHAND DETECTED 2."));
                            }
                        }
                        boolean converted = AP2CDUtils.convertHornIfNeeded(item2, player, instance, mainOffHand);
                        if (debugMode) {
                            player.sendMessage((Component)Component.text((String)("AP2CD-DEBUG-005 - Converted result: " + converted + ".")));
                        }
                        if (converted) {
                            if (mainOffHand) {
                                player.getInventory().setItemInMainHand(item2);
                                player.setCooldown(Material.GOAT_HORN, 0);
                                if (debugMode) {
                                    player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-006A - Goat horn converted from MAINHAND."));
                                }
                            } else {
                                player.getInventory().setItemInOffHand(item2);
                                player.setCooldown(Material.GOAT_HORN, 0);
                                if (debugMode) {
                                    player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-006B - Goat horn converted from OFFHAND."));
                                }
                            }
                        } else if (debugMode) {
                            player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-007 - Goat horn NOT converted."));
                        }
                    });
                }
            });
        }
        this.pluginLogger.info("Successfully registered AudioPlayer2CustomDiscs plugin!");
    }

    public void onDisable() {
        CommandAPI.onDisable();
        if (this.pluginLogger != null) {
            this.pluginLogger.info("Successfully unregistered AudioPlayer2CustomDiscs plugin!");
        }
    }

    public static AudioPlayer2CustomDiscs getInstance() {
        return instance;
    }

    public static boolean getDebugMode() {
        return debugMode;
    }

    public static boolean getReverseAutomaticConvertMode() {
        return !automaticConvertMode;
    }

    public static Component[] getHelpMessage() {
        return helpMessage;
    }

    static {
        LegacyComponentAmpersand = LegacyComponentSerializer.legacyAmpersand();
        debugMode = false;
        automaticConvertMode = false;
    }
}

