/*
 * Decompiled with CFR 0.152.
 */
package me.Athar42.ap2cd.command.SubCommands;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.Athar42.ap2cd.AudioPlayer2CustomDiscs;
import me.Athar42.ap2cd.utils.AP2CDUtils;
import me.Athar42.ap2cd.utils.TypeChecker;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPICommand;
import me.Athar42.audioplayer2customdiscs.commandapi.executors.CommandArguments;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.component.CustomData;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Convert
extends CommandAPICommand {
    AudioPlayer2CustomDiscs plugin = AudioPlayer2CustomDiscs.getInstance();

    public Convert(AudioPlayer2CustomDiscs plugin) {
        super("convert");
        this.withFullDescription(String.valueOf(NamedTextColor.GRAY) + "Convert from AudioPlayer to CustomDiscs format.");
        this.withUsage("/ap2cd convert");
        this.executesPlayer(this::onCommandPlayer);
        this.executesConsole(this::onCommandConsole);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int onCommandPlayer(Player player, CommandArguments arguments) {
        UUID uuid;
        CustomData customDataRetrieval;
        boolean resultIsHorn;
        boolean resultIsMusicDisc;
        block28: {
            NamespacedKey convertedKeyRetrieval;
            ItemStack item = player.getInventory().getItemInMainHand();
            resultIsMusicDisc = TypeChecker.isMusicDisc(item);
            resultIsHorn = TypeChecker.isGoatHornPlayer(player);
            boolean resultIsHead = TypeChecker.isHeadPlayer(player);
            if (!(resultIsMusicDisc || resultIsHorn || resultIsHead)) {
                player.sendMessage((Component)Component.text((String)"AP2CD - Not holding a music disc, goat horn or player head!"));
                return 0;
            }
            PersistentDataContainer itemPDCdata = item.getItemMeta().getPersistentDataContainer();
            Boolean isConverted = (Boolean)itemPDCdata.get(convertedKeyRetrieval = new NamespacedKey((Plugin)this.plugin, "converted"), PersistentDataType.BOOLEAN);
            if (isConverted != null && isConverted.booleanValue()) {
                player.sendMessage((Component)Component.text((String)"AP2CD - Item is already converted."));
                return 0;
            }
            net.minecraft.world.item.ItemStack itemCopyAsNMS = CraftItemStack.asNMSCopy((ItemStack)item);
            if (!itemCopyAsNMS.has(DataComponents.CUSTOM_DATA)) {
                if (this.isDebugEnabled()) {
                    player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-038 - This item has no 'minecraft:custom_data' - Not converting."));
                }
                return 0;
            }
            customDataRetrieval = (CustomData)itemCopyAsNMS.get(DataComponents.CUSTOM_DATA);
            CompoundTag tagCompoundRetrieval = customDataRetrieval.copyTag();
            uuid = null;
            if (tagCompoundRetrieval.contains("CustomSound")) {
                Tag tagSoundRetrieval = tagCompoundRetrieval.get("CustomSound");
                if (tagSoundRetrieval instanceof IntArrayTag) {
                    IntArrayTag intArrayTag = (IntArrayTag)tagSoundRetrieval;
                    int[] ints = intArrayTag.getAsIntArray();
                    if (ints.length == 4) {
                        long msb = (long)ints[0] << 32 | (long)ints[1] & 0xFFFFFFFFL;
                        long lsb = (long)ints[2] << 32 | (long)ints[3] & 0xFFFFFFFFL;
                        uuid = new UUID(msb, lsb);
                        break block28;
                    } else {
                        if (this.isDebugEnabled()) {
                            player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-039 - The 'CustomSound' format is invalid - Not converting."));
                        }
                        return 0;
                    }
                }
                if (this.isDebugEnabled()) {
                    player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-040 - The 'CustomSound' tag exists but is not an IntArrayTag - Not converting."));
                }
                return 0;
            }
            if (tagCompoundRetrieval.contains("audioplayer")) {
                Tag audioplayerTagRetrieval = tagCompoundRetrieval.get("audioplayer");
                if (audioplayerTagRetrieval instanceof StringTag) {
                    StringTag stringTag = (StringTag)audioplayerTagRetrieval;
                    String json = stringTag.toString();
                    String extractedUUIDString = Convert.extractUUIDFromAudioPlayer(json);
                    if (extractedUUIDString != null) {
                        try {
                            uuid = UUID.fromString(extractedUUIDString);
                        }
                        catch (IllegalArgumentException ex) {
                            if (this.isDebugEnabled()) {
                                player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-041 - Invalid UUID format from audioplayer JSON."));
                            }
                            return 0;
                        }
                    } else {
                        if (this.isDebugEnabled()) {
                            player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-042 - Could not extract UUID from audioplayer JSON."));
                        }
                        return 0;
                    }
                }
                if (this.isDebugEnabled()) {
                    player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-043 - 'audioplayer' tag exists but is not a StringTag."));
                }
                return 0;
            }
            if (this.isDebugEnabled()) {
                player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-044 - Item has no 'CustomSound' or 'audioplayer' value - Not converting."));
            }
            return 0;
        }
        Tag tagSoundRangeRetrieval = customDataRetrieval.copyTag().get("CustomSoundRange");
        Float retrievedRangeValue = null;
        if (tagSoundRangeRetrieval instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tagSoundRangeRetrieval;
            retrievedRangeValue = Float.valueOf(floatTag.floatValue());
        } else if (this.isDebugEnabled()) {
            player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-045 - This item has no 'CustomSoundRange' value."));
        }
        File audioPlayerFolder = new File(Bukkit.getWorldContainer(), "plugins/CustomDiscs/musicdata");
        String convertedFilename = AP2CDUtils.findSoundFile(audioPlayerFolder, uuid);
        if (convertedFilename == null) {
            player.sendMessage((Component)Component.text((String)("AP2CD - ERROR : No matching sound file found for UUID " + String.valueOf(uuid) + ".")));
            return 0;
        }
        if (resultIsMusicDisc) {
            this.setDiscMeta(player, true, convertedFilename, retrievedRangeValue);
        } else if (resultIsHorn) {
            this.setHornMeta(player, true, convertedFilename, retrievedRangeValue);
        } else {
            this.setHeadMeta(player, true, convertedFilename, retrievedRangeValue);
        }
        player.sendMessage((Component)Component.text((String)"AP2CD - Item has been converted!"));
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean convertItemHorn(Player player, ItemStack item, boolean isMainOffHand) {
        UUID uuid;
        CustomData customDataRetrieval;
        block23: {
            boolean resultIsHorn = TypeChecker.isGoatHornPlayer(player);
            if (!resultIsHorn) {
                player.sendMessage((Component)Component.text((String)"AP2CD - Not holding a goat horn!"));
                return false;
            }
            net.minecraft.world.item.ItemStack itemCopyAsNMS = CraftItemStack.asNMSCopy((ItemStack)item);
            if (!itemCopyAsNMS.has(DataComponents.CUSTOM_DATA)) {
                if (this.isDebugEnabled()) {
                    player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-046 - This item has no 'minecraft:custom_data' - Not converting."));
                }
                return false;
            }
            customDataRetrieval = (CustomData)itemCopyAsNMS.get(DataComponents.CUSTOM_DATA);
            CompoundTag tagCompoundRetrieval = customDataRetrieval.copyTag();
            uuid = null;
            if (tagCompoundRetrieval.contains("CustomSound")) {
                Tag tagSoundRetrieval = tagCompoundRetrieval.get("CustomSound");
                if (tagSoundRetrieval instanceof IntArrayTag) {
                    IntArrayTag intArrayTag = (IntArrayTag)tagSoundRetrieval;
                    int[] ints = intArrayTag.getAsIntArray();
                    if (ints.length == 4) {
                        long msb = (long)ints[0] << 32 | (long)ints[1] & 0xFFFFFFFFL;
                        long lsb = (long)ints[2] << 32 | (long)ints[3] & 0xFFFFFFFFL;
                        uuid = new UUID(msb, lsb);
                        break block23;
                    } else {
                        if (this.isDebugEnabled()) {
                            player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-047 - The 'CustomSound' format is invalid - Not converting."));
                        }
                        return false;
                    }
                }
                if (this.isDebugEnabled()) {
                    player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-048 - The 'CustomSound' tag exists but is not an IntArrayTag - Not converting."));
                }
                return false;
            }
            if (tagCompoundRetrieval.contains("audioplayer")) {
                Tag audioplayerTagRetrieval = tagCompoundRetrieval.get("audioplayer");
                if (audioplayerTagRetrieval instanceof StringTag) {
                    StringTag stringTag = (StringTag)audioplayerTagRetrieval;
                    String json = stringTag.toString();
                    String extractedUUIDString = Convert.extractUUIDFromAudioPlayer(json);
                    if (extractedUUIDString != null) {
                        try {
                            uuid = UUID.fromString(extractedUUIDString);
                        }
                        catch (IllegalArgumentException ex) {
                            if (this.isDebugEnabled()) {
                                player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-049 - Invalid UUID format from audioplayer JSON."));
                            }
                            return false;
                        }
                    } else {
                        if (this.isDebugEnabled()) {
                            player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-050 - Could not extract UUID from audioplayer JSON."));
                        }
                        return false;
                    }
                }
                if (this.isDebugEnabled()) {
                    player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-051 - 'audioplayer' tag exists but is not a StringTag."));
                }
                return false;
            }
            if (this.isDebugEnabled()) {
                player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-052 - Item has no 'CustomSound' or 'audioplayer' value - Not converting."));
            }
            return false;
        }
        Tag tagSoundRangeRetrieval = customDataRetrieval.copyTag().get("CustomSoundRange");
        Float retrievedRangeValue = null;
        if (tagSoundRangeRetrieval instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tagSoundRangeRetrieval;
            retrievedRangeValue = Float.valueOf(floatTag.floatValue());
        } else if (this.isDebugEnabled()) {
            player.sendMessage((Component)Component.text((String)"AP2CD-DEBUG-053 - This item has no 'CustomSoundRange' value."));
        }
        File audioPlayerFolder = new File(Bukkit.getWorldContainer(), "plugins/CustomDiscs/musicdata");
        String convertedFilename = AP2CDUtils.findSoundFile(audioPlayerFolder, uuid);
        if (convertedFilename == null) {
            player.sendMessage((Component)Component.text((String)("AP2CD - ERROR : No matching sound file found for UUID " + String.valueOf(uuid) + ".")));
            return false;
        }
        this.setHornMeta(player, isMainOffHand, convertedFilename, retrievedRangeValue);
        player.sendMessage((Component)Component.text((String)"AP2CD - Item has been converted!"));
        return true;
    }

    public void setDiscMeta(Player player, boolean isMainOffHand, String convertedFilename, Float retrievedRangeValue) {
        ItemStack discItemStack = isMainOffHand ? new ItemStack(player.getInventory().getItemInMainHand()) : new ItemStack(player.getInventory().getItemInOffHand());
        discItemStack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)TooltipDisplay.tooltipDisplay().addHiddenComponents(new DataComponentType[]{DataComponentTypes.JUKEBOX_PLAYABLE}).build()));
        ItemMeta discMeta = discItemStack.getItemMeta();
        ArrayList<TextComponent> itemLore = new ArrayList<TextComponent>();
        TextComponent customLoreSong = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().decoration(TextDecoration.ITALIC, false)).content("AudioPlayer converted disc").color((TextColor)NamedTextColor.GRAY)).build();
        itemLore.add(customLoreSong);
        discMeta.lore(itemLore);
        PersistentDataContainer discPDCdata = discMeta.getPersistentDataContainer();
        discPDCdata.set(new NamespacedKey("customdiscs", "customdisc"), PersistentDataType.STRING, (Object)convertedFilename);
        if (retrievedRangeValue != null) {
            discPDCdata.set(new NamespacedKey("customdiscs", "range"), PersistentDataType.FLOAT, (Object)retrievedRangeValue);
        }
        discPDCdata.set(new NamespacedKey((Plugin)this.plugin, "converted"), PersistentDataType.BOOLEAN, (Object)true);
        if (isMainOffHand) {
            player.getInventory().getItemInMainHand().setItemMeta(discMeta);
        } else {
            player.getInventory().getItemInOffHand().setItemMeta(discMeta);
        }
    }

    public void setHornMeta(Player player, boolean isMainOffHand, String convertedFilename, Float retrievedRangeValue) {
        ItemStack hornItemStack = isMainOffHand ? new ItemStack(player.getInventory().getItemInMainHand()) : new ItemStack(player.getInventory().getItemInOffHand());
        ItemMeta hornMeta = hornItemStack.getItemMeta();
        PersistentDataContainer hornPDCdata = hornMeta.getPersistentDataContainer();
        hornPDCdata.set(new NamespacedKey("customdiscs", "customhorn"), PersistentDataType.STRING, (Object)convertedFilename);
        hornPDCdata.set(new NamespacedKey("customdiscs", "goat_horn_cooldown"), PersistentDataType.INTEGER, (Object)20);
        if (retrievedRangeValue != null) {
            hornPDCdata.set(new NamespacedKey("customdiscs", "range"), PersistentDataType.FLOAT, (Object)retrievedRangeValue);
        }
        hornPDCdata.set(new NamespacedKey((Plugin)this.plugin, "converted"), PersistentDataType.BOOLEAN, (Object)true);
        if (isMainOffHand) {
            player.getInventory().getItemInMainHand().setItemMeta(hornMeta);
        } else {
            player.getInventory().getItemInOffHand().setItemMeta(hornMeta);
        }
    }

    public void setHeadMeta(Player player, boolean isMainOffHand, String convertedFilename, Float retrievedRangeValue) {
        BuildableComponent headCustomLore = ((TextComponent.Builder)((TextComponent.Builder)Component.text().decoration(TextDecoration.ITALIC, false)).content("AudioPlayer converted head").color((TextColor)NamedTextColor.GRAY)).build();
        String serializedComponent = (String)GsonComponentSerializer.gson().serialize((Component)headCustomLore);
        ItemStack headItemStack = isMainOffHand ? new ItemStack(player.getInventory().getItemInMainHand()) : new ItemStack(player.getInventory().getItemInOffHand());
        ItemMeta headMeta = headItemStack.getItemMeta();
        ArrayList<TextComponent> itemLore = new ArrayList<TextComponent>();
        TextComponent customLoreSong = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().decoration(TextDecoration.ITALIC, false)).content("AudioPlayer converted head").color((TextColor)NamedTextColor.GRAY)).build();
        itemLore.add(customLoreSong);
        headMeta.lore(itemLore);
        PersistentDataContainer headPDCdata = headMeta.getPersistentDataContainer();
        headPDCdata.set(new NamespacedKey("customdiscs", "customhead"), PersistentDataType.STRING, (Object)convertedFilename);
        headPDCdata.set(new NamespacedKey("customdiscs", "headlore"), PersistentDataType.STRING, (Object)serializedComponent);
        if (retrievedRangeValue != null) {
            headPDCdata.set(new NamespacedKey("customdiscs", "range"), PersistentDataType.FLOAT, (Object)retrievedRangeValue);
        }
        headPDCdata.set(new NamespacedKey((Plugin)this.plugin, "converted"), PersistentDataType.BOOLEAN, (Object)true);
        if (isMainOffHand) {
            player.getInventory().getItemInMainHand().setItemMeta(headMeta);
        } else {
            player.getInventory().getItemInOffHand().setItemMeta(headMeta);
        }
    }

    public static String extractUUIDFromAudioPlayer(String json) {
        Pattern patternLookup = Pattern.compile("\"id\"\\s*:\\s*\"([0-9a-fA-F-]{36})\"");
        Matcher matcherLookup = patternLookup.matcher(json);
        return matcherLookup.find() ? matcherLookup.group(1) : null;
    }

    private int onCommandConsole(ConsoleCommandSender executor, CommandArguments arguments) {
        executor.sendMessage(String.valueOf(NamedTextColor.RED) + "AP2CD - Only players can use this command : '" + String.valueOf(arguments) + "'!");
        return 1;
    }

    private boolean isDebugEnabled() {
        return AudioPlayer2CustomDiscs.getDebugMode();
    }
}

