/*
 * Decompiled with CFR 0.152.
 */
package me.Athar42.audioplayer2customdiscs.commandapi;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import me.Athar42.audioplayer2customdiscs.commandapi.CommandAPI;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.AbstractBlockCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.AbstractCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.AbstractConsoleCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.AbstractEntity;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.AbstractFeedbackForwardingCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.AbstractPlayer;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.AbstractProxiedCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.commandsenders.AbstractRemoteConsoleCommandSender;
import me.Athar42.audioplayer2customdiscs.commandapi.exceptions.WrapperCommandSyntaxException;
import me.Athar42.audioplayer2customdiscs.commandapi.executors.ExecutionInfo;
import me.Athar42.audioplayer2customdiscs.commandapi.executors.ExecutorType;
import me.Athar42.audioplayer2customdiscs.commandapi.executors.NormalExecutor;
import me.Athar42.audioplayer2customdiscs.commandapi.executors.ResultingExecutor;
import me.Athar42.audioplayer2customdiscs.commandapi.executors.TypedExecutor;

public class CommandAPIExecutor<CommandSender, WrapperType extends AbstractCommandSender<? extends CommandSender>> {
    private List<NormalExecutor<CommandSender, WrapperType>> normalExecutors = new ArrayList<NormalExecutor<CommandSender, WrapperType>>();
    private List<ResultingExecutor<CommandSender, WrapperType>> resultingExecutors = new ArrayList<ResultingExecutor<CommandSender, WrapperType>>();

    public void addNormalExecutor(NormalExecutor<?, ?> executor) {
        this.normalExecutors.add(executor);
    }

    public void addResultingExecutor(ResultingExecutor<?, ?> executor) {
        this.resultingExecutors.add(executor);
    }

    public int execute(ExecutionInfo<CommandSender, WrapperType> info) throws CommandSyntaxException {
        if (!this.resultingExecutors.isEmpty()) {
            try {
                return this.execute(this.resultingExecutors, info);
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
            catch (Throwable ex) {
                CommandAPI.getLogger().severe("Unhandled exception executing '" + info.args().fullInput() + "'", ex);
                if (ex instanceof Exception) {
                    throw ex;
                }
                throw new RuntimeException(ex);
            }
        }
        try {
            return this.execute(this.normalExecutors, info);
        }
        catch (WrapperCommandSyntaxException e) {
            throw e.getException();
        }
        catch (Throwable ex) {
            CommandAPI.getLogger().severe("Unhandled exception executing '" + info.args().fullInput() + "'", ex);
            if (ex instanceof Exception) {
                throw ex;
            }
            throw new RuntimeException(ex);
        }
    }

    private int execute(List<? extends TypedExecutor<CommandSender, WrapperType>> executors, ExecutionInfo<CommandSender, WrapperType> info) throws WrapperCommandSyntaxException {
        if (this.isForceNative()) {
            return this.execute(executors, info, ExecutorType.NATIVE);
        }
        if (info.senderWrapper() instanceof AbstractPlayer && this.matches(executors, ExecutorType.PLAYER)) {
            return this.execute(executors, info, ExecutorType.PLAYER);
        }
        if (info.senderWrapper() instanceof AbstractEntity && this.matches(executors, ExecutorType.ENTITY)) {
            return this.execute(executors, info, ExecutorType.ENTITY);
        }
        if (info.senderWrapper() instanceof AbstractConsoleCommandSender && this.matches(executors, ExecutorType.CONSOLE)) {
            return this.execute(executors, info, ExecutorType.CONSOLE);
        }
        if (info.senderWrapper() instanceof AbstractBlockCommandSender && this.matches(executors, ExecutorType.BLOCK)) {
            return this.execute(executors, info, ExecutorType.BLOCK);
        }
        if (info.senderWrapper() instanceof AbstractProxiedCommandSender && this.matches(executors, ExecutorType.PROXY)) {
            return this.execute(executors, info, ExecutorType.PROXY);
        }
        if (info.senderWrapper() instanceof AbstractRemoteConsoleCommandSender && this.matches(executors, ExecutorType.REMOTE)) {
            return this.execute(executors, info, ExecutorType.REMOTE);
        }
        if (info.senderWrapper() instanceof AbstractFeedbackForwardingCommandSender && this.matches(executors, ExecutorType.FEEDBACK_FORWARDING)) {
            return this.execute(executors, info, ExecutorType.FEEDBACK_FORWARDING);
        }
        if (this.matches(executors, ExecutorType.ALL)) {
            return this.execute(executors, info, ExecutorType.ALL);
        }
        throw new WrapperCommandSyntaxException(new SimpleCommandExceptionType((Message)new LiteralMessage(CommandAPI.getConfiguration().getMissingImplementationMessage().replace("%s", info.sender().getClass().getSimpleName().toLowerCase()).replace("%S", info.sender().getClass().getSimpleName()))).create());
    }

    private int execute(List<? extends TypedExecutor<CommandSender, WrapperType>> executors, ExecutionInfo<CommandSender, WrapperType> info, ExecutorType type) throws WrapperCommandSyntaxException {
        for (TypedExecutor<CommandSender, WrapperType> executor : executors) {
            if (executor.getType() != type) continue;
            return executor.executeWith(info);
        }
        throw new NoSuchElementException("Executor had no valid executors for type " + type.toString());
    }

    public List<NormalExecutor<CommandSender, WrapperType>> getNormalExecutors() {
        return this.normalExecutors;
    }

    public List<ResultingExecutor<CommandSender, WrapperType>> getResultingExecutors() {
        return this.resultingExecutors;
    }

    public boolean hasAnyExecutors() {
        return !this.normalExecutors.isEmpty() || !this.resultingExecutors.isEmpty();
    }

    public boolean isForceNative() {
        return this.matches(this.normalExecutors, ExecutorType.NATIVE) || this.matches(this.resultingExecutors, ExecutorType.NATIVE);
    }

    private boolean matches(List<? extends TypedExecutor<?, ?>> executors, ExecutorType type) {
        for (TypedExecutor<?, ?> executor : executors) {
            if (executor.getType() != type) continue;
            return true;
        }
        return false;
    }

    CommandAPIExecutor<CommandSender, WrapperType> mergeExecutor(CommandAPIExecutor<CommandSender, WrapperType> executor) {
        CommandAPIExecutor<CommandSender, WrapperType> result = new CommandAPIExecutor<CommandSender, WrapperType>();
        result.normalExecutors = new ArrayList<NormalExecutor<CommandSender, WrapperType>>(this.normalExecutors);
        result.resultingExecutors = new ArrayList<ResultingExecutor<CommandSender, WrapperType>>(this.resultingExecutors);
        result.normalExecutors.addAll(executor.normalExecutors);
        result.resultingExecutors.addAll(executor.resultingExecutors);
        return result;
    }

    public void setNormalExecutors(List<NormalExecutor<CommandSender, WrapperType>> normalExecutors) {
        this.normalExecutors = normalExecutors;
    }

    public void setResultingExecutors(List<ResultingExecutor<CommandSender, WrapperType>> resultingExecutors) {
        this.resultingExecutors = resultingExecutors;
    }
}

