/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.hangglider.HangGlider;
import fuzs.hangglider.attachment.Gliding;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.init.ModRegistry;
import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionfc;

public class GliderRenderHandler {
    public static final ContextKey<ItemStack> GLIDER_IN_HAND_KEY = new ContextKey(HangGlider.id("glider_in_hand"));
    public static final ContextKey<Boolean> IS_GLIDING_KEY = new ContextKey(HangGlider.id("is_gliding"));
    public static final ContextKey<Float> HEAD_ROT_KEY = new ContextKey(HangGlider.id("head_rot"));
    private static boolean appliedGlidingRotations;

    public static void onExtractRenderState(Entity entity, EntityRenderState renderState, float partialTick) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (renderState instanceof AvatarRenderState) {
                AvatarRenderState avatarRenderState = (AvatarRenderState)renderState;
                RenderStateExtraData.set((EntityRenderState)renderState, GLIDER_IN_HAND_KEY, (Object)PlayerGlidingHelper.getGliderInHand(player));
                RenderStateExtraData.set((EntityRenderState)renderState, IS_GLIDING_KEY, (Object)((Gliding)ModRegistry.GLIDING_ATTACHMENT_TYPE.get((Object)player)).gliding());
                RenderStateExtraData.set((EntityRenderState)renderState, HEAD_ROT_KEY, (Object)Float.valueOf(Mth.rotLerp((float)partialTick, (float)player.yHeadRotO, (float)player.yHeadRot)));
                if (((Boolean)RenderStateExtraData.getOrDefault((EntityRenderState)renderState, IS_GLIDING_KEY, (Object)false)).booleanValue()) {
                    avatarRenderState.rightHandItem.clear();
                    avatarRenderState.leftHandItem.clear();
                    avatarRenderState.rightArmPose = avatarRenderState.leftArmPose = HumanoidModel.ArmPose.EMPTY;
                    avatarRenderState.isCrouching = false;
                }
            }
        }
    }

    public static <T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>> EventResult onBeforeRenderEntity(S entityRenderState, LivingEntityRenderer<T, S, M> entityRenderer, float partialTick, PoseStack poseStack, SubmitNodeCollector submitNodeCollector) {
        if (entityRenderState instanceof AvatarRenderState) {
            AvatarRenderState avatarRenderState = (AvatarRenderState)entityRenderState;
            if (entityRenderer instanceof AvatarRenderer && ((Boolean)RenderStateExtraData.getOrDefault(entityRenderState, IS_GLIDING_KEY, (Object)false)).booleanValue()) {
                float headRot = ((Float)RenderStateExtraData.getOrDefault(entityRenderState, HEAD_ROT_KEY, (Object)Float.valueOf(0.0f))).floatValue();
                poseStack.pushPose();
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-headRot));
                poseStack.translate(0.0f, avatarRenderState.boundingBoxHeight / 2.0f, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                poseStack.translate(0.0f, -avatarRenderState.boundingBoxHeight / 2.0f, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(headRot));
                poseStack.translate(0.0f, -0.5f, 0.0f);
                appliedGlidingRotations = true;
            }
        }
        return EventResult.PASS;
    }

    public static <T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>> void onAfterRenderEntity(S entityRenderState, LivingEntityRenderer<T, S, M> entityRenderer, float partialTick, PoseStack poseStack, SubmitNodeCollector submitNodeCollector) {
        if (entityRenderState instanceof AvatarRenderState && entityRenderer instanceof AvatarRenderer && appliedGlidingRotations) {
            appliedGlidingRotations = false;
            poseStack.popPose();
        }
    }
}

