/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.hangglider.HangGlider;
import fuzs.hangglider.attachment.Gliding;
import fuzs.hangglider.config.ClientConfig;
import fuzs.hangglider.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class GlidingCameraHandler {
    private static float gliderRotation;
    private static float gliderRotationOld;
    private static CameraType oldCameraType;

    public static void onEndClientTick(Minecraft minecraft) {
        if (minecraft.player != null) {
            if (((ClientConfig)HangGlider.CONFIG.get(ClientConfig.class)).autoThirdPersonGliding) {
                GlidingCameraHandler.setThirdPersonGliding((Player)minecraft.player, minecraft.options);
            }
            if (((ClientConfig)HangGlider.CONFIG.get(ClientConfig.class)).glidingCameraTilt) {
                GlidingCameraHandler.updateGlidingRotation((Player)minecraft.player);
            }
        }
    }

    private static void setThirdPersonGliding(Player player, Options options) {
        if (((Gliding)ModRegistry.GLIDING_ATTACHMENT_TYPE.get((Object)player)).gliding()) {
            if (oldCameraType == null) {
                oldCameraType = options.getCameraType();
                if (options.getCameraType() == CameraType.FIRST_PERSON) {
                    options.setCameraType(CameraType.THIRD_PERSON_BACK);
                }
            }
        } else if (oldCameraType != null) {
            if (options.getCameraType() == CameraType.THIRD_PERSON_BACK) {
                options.setCameraType(oldCameraType);
            }
            oldCameraType = null;
        }
    }

    private static void updateGlidingRotation(Player player) {
        if (((Gliding)ModRegistry.GLIDING_ATTACHMENT_TYPE.get((Object)player)).gliding()) {
            Vec3 vector3d = player.getViewVector(1.0f);
            Vec3 vector3d1 = player.getDeltaMovement();
            double d0 = vector3d1.horizontalDistanceSqr();
            double d1 = vector3d.horizontalDistanceSqr();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.x * vector3d.x + vector3d1.z * vector3d.z) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.x * vector3d.z - vector3d1.z * vector3d.x;
                float rotationDelta = (float)(Math.signum(d3) * Math.acos(Math.min(d2, 1.0)));
                gliderRotationOld = gliderRotation;
                gliderRotation += ((rotationDelta *= 22.91831f * (float)((ClientConfig)HangGlider.CONFIG.get(ClientConfig.class)).glidingTiltAmount) - gliderRotation) * (float)((ClientConfig)HangGlider.CONFIG.get(ClientConfig.class)).glidingTiltSpeed;
            }
        } else {
            gliderRotation = 0.0f;
            gliderRotationOld = 0.0f;
        }
    }

    public static void onComputeCameraRoll(GameRenderer gameRenderer, Camera camera, float partialTick, MutableFloat pitch, MutableFloat yaw, MutableFloat roll) {
        if (((ClientConfig)HangGlider.CONFIG.get(ClientConfig.class)).glidingCameraTilt && (gliderRotation != 0.0f || gliderRotationOld != 0.0f)) {
            roll.accept(Mth.lerp((float)partialTick, (float)gliderRotationOld, (float)gliderRotation));
        }
    }

    public static EventResult onRenderHand(ItemInHandRenderer itemInHandRenderer, InteractionHand interactionHand, AbstractClientPlayer player, HumanoidArm humanoidArm, ItemStack itemStack, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int combinedLight, float partialTick, float interpolatedPitch, float swingProgress, float equipProgress) {
        return ((Gliding)ModRegistry.GLIDING_ATTACHMENT_TYPE.get((Object)player)).gliding() ? EventResult.INTERRUPT : EventResult.PASS;
    }
}

