/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.handler;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.attachment.Gliding;
import fuzs.hangglider.config.ServerConfig;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.init.ModRegistry;
import fuzs.hangglider.mixin.accessor.ServerGamePacketListenerImplAccessor;
import fuzs.hangglider.world.wind.WindHelper;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class PlayerGlidingHandler {
    public static void onEndPlayerTick(Player player) {
        Gliding gliding = (Gliding)ModRegistry.GLIDING_ATTACHMENT_TYPE.get((Object)player);
        ItemStack itemStack = PlayerGlidingHelper.getGliderInHand(player);
        if (!itemStack.isEmpty() && !PlayerGlidingHelper.isWearingElytra(player)) {
            if (PlayerGlidingHelper.isAllowedToGlide(player)) {
                gliding = gliding.withGliding(true);
                ServerConfig.GliderConfig config = PlayerGlidingHelper.getGliderMaterialSettings(itemStack);
                PlayerGlidingHandler.handleGlidingMovement(player, itemStack, config);
                if (!player.level().isClientSide()) {
                    PlayerGlidingHandler.handleGliderDurability(player, itemStack, config);
                    ((ServerGamePacketListenerImplAccessor)((ServerPlayer)player).connection).hangglider$setAboveGroundTickCount(0);
                    ((ServerGamePacketListenerImplAccessor)((ServerPlayer)player).connection).hangglider$setAboveGroundVehicleTickCount(0);
                }
                PlayerGlidingHandler.resetClientAnimations(player);
            } else {
                gliding = gliding.withGliding(false);
            }
        } else {
            gliding = Gliding.EMPTY;
        }
        if (!player.level().isClientSide()) {
            ModRegistry.GLIDING_ATTACHMENT_TYPE.set((Object)player, (Object)gliding);
        }
    }

    public static void resetClientAnimations(Player player) {
        player.walkAnimation.setSpeed(0.0f);
        player.walkAnimation.position(0.0f);
    }

    private static void handleGlidingMovement(Player player, ItemStack stack, ServerConfig.GliderConfig glider) {
        double verticalSpeed;
        double horizontalSpeed;
        if (player.isDescending()) {
            horizontalSpeed = glider.fastHorizontalSpeed;
            verticalSpeed = glider.fastVerticalSpeed;
        } else {
            horizontalSpeed = glider.horizontalSpeed;
            verticalSpeed = glider.verticalSpeed;
        }
        WindHelper.applyWind(player, stack);
        Vec3 movement = player.getDeltaMovement();
        double deltaX = Math.cos(Math.toRadians(player.getYRot() + 90.0f)) * horizontalSpeed;
        double deltaZ = Math.sin(Math.toRadians(player.getYRot() + 90.0f)) * horizontalSpeed;
        player.setDeltaMovement(movement.x + deltaX, movement.y * verticalSpeed, movement.z + deltaZ);
        if (((ServerConfig)HangGlider.CONFIG.get(ServerConfig.class)).wind.allowAirResistance) {
            movement = player.getDeltaMovement();
            double airResistance = glider.airResistance;
            player.setDeltaMovement(movement.x * airResistance, movement.y, movement.z * airResistance);
        }
        if (player.getDeltaMovement().y > -0.5) {
            player.fallDistance = 1.0;
        }
    }

    private static void handleGliderDurability(Player player, ItemStack itemStack, ServerConfig.GliderConfig gliderMaterialSettings) {
        if (gliderMaterialSettings.consumeDurability && player.getRandom().nextInt(gliderMaterialSettings.durabilityUseInterval) == 0) {
            EquipmentSlot equipmentSlot = PlayerGlidingHelper.getGliderHoldingHand(player);
            Objects.requireNonNull(equipmentSlot, "equipment slot is null");
            itemStack.hurtAndBreak(1, (LivingEntity)player, equipmentSlot);
        }
    }
}

