/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.helper;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.attachment.Gliding;
import fuzs.hangglider.config.ServerConfig;
import fuzs.hangglider.init.ModRegistry;
import fuzs.hangglider.world.item.component.HangGliderComponent;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerGlidingHelper {
    public static boolean isAllowedToGlide(Player player) {
        return !player.onGround() && !player.isPassenger() && !player.hasEffect(MobEffects.LEVITATION) && !player.getAbilities().flying && !player.isInWater() && player.getDeltaMovement().y < 0.0;
    }

    public static boolean isWearingElytra(Player player) {
        return player.getItemBySlot(EquipmentSlot.CHEST).has(DataComponents.GLIDER);
    }

    public static boolean isValidGlider(ItemStack itemStack) {
        return itemStack.has((DataComponentType)ModRegistry.HANG_GLIDER_DATA_COMPONENT_TYPE.value()) && !itemStack.nextDamageWillBreak();
    }

    public static ItemStack getGliderInHand(Player player) {
        if (((Gliding)ModRegistry.GLIDING_ATTACHMENT_TYPE.get((Object)player)).deployed()) {
            for (InteractionHand interactionHand : InteractionHand.values()) {
                ItemStack itemInHand = player.getItemInHand(interactionHand);
                if (!PlayerGlidingHelper.isValidGlider(itemInHand)) continue;
                return itemInHand;
            }
        }
        return ItemStack.EMPTY;
    }

    public static EquipmentSlot getGliderHoldingHand(Player player) {
        for (InteractionHand interactionHand : InteractionHand.values()) {
            ItemStack itemInHand = player.getItemInHand(interactionHand);
            if (!itemInHand.has((DataComponentType)ModRegistry.HANG_GLIDER_DATA_COMPONENT_TYPE.value())) continue;
            return interactionHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        }
        return null;
    }

    public static ServerConfig.GliderConfig getGliderMaterialSettings(ItemStack itemStack) {
        HangGliderComponent hangGlider = (HangGliderComponent)itemStack.get((DataComponentType)ModRegistry.HANG_GLIDER_DATA_COMPONENT_TYPE.value());
        if (hangGlider != null) {
            if (hangGlider.isReinforced()) {
                return ((ServerConfig)HangGlider.CONFIG.get(ServerConfig.class)).reinforcedHangGlider;
            }
            return ((ServerConfig)HangGlider.CONFIG.get(ServerConfig.class)).hangGlider;
        }
        throw new IllegalArgumentException(String.valueOf(itemStack) + " is no hang glider");
    }
}

