/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.handler;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.attachment.Gliding;
import fuzs.hangglider.config.ServerConfig;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.init.ModRegistry;
import fuzs.hangglider.mixin.accessor.ServerGamePacketListenerImplAccessor;
import fuzs.hangglider.world.wind.WindHelper;
import java.util.Objects;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3222;

public class PlayerGlidingHandler {
    public static void onEndPlayerTick(class_1657 player) {
        Gliding gliding = (Gliding)ModRegistry.GLIDING_ATTACHMENT_TYPE.get((Object)player);
        class_1799 itemStack = PlayerGlidingHelper.getGliderInHand(player);
        if (!itemStack.method_7960() && !PlayerGlidingHelper.isWearingElytra(player)) {
            if (PlayerGlidingHelper.isAllowedToGlide(player)) {
                gliding = gliding.withGliding(true);
                ServerConfig.GliderConfig config = PlayerGlidingHelper.getGliderMaterialSettings(itemStack);
                PlayerGlidingHandler.handleGlidingMovement(player, itemStack, config);
                if (!player.method_73183().method_8608()) {
                    PlayerGlidingHandler.handleGliderDurability(player, itemStack, config);
                    ((ServerGamePacketListenerImplAccessor)((class_3222)player).field_13987).hangglider$setAboveGroundTickCount(0);
                    ((ServerGamePacketListenerImplAccessor)((class_3222)player).field_13987).hangglider$setAboveGroundVehicleTickCount(0);
                }
                PlayerGlidingHandler.resetClientAnimations(player);
            } else {
                gliding = gliding.withGliding(false);
            }
        } else {
            gliding = Gliding.EMPTY;
        }
        if (!player.method_73183().method_8608()) {
            ModRegistry.GLIDING_ATTACHMENT_TYPE.set((Object)player, (Object)gliding);
        }
    }

    public static void resetClientAnimations(class_1657 player) {
        player.field_42108.method_48567(0.0f);
        player.field_42108.method_48572(0.0f);
    }

    private static void handleGlidingMovement(class_1657 player, class_1799 stack, ServerConfig.GliderConfig glider) {
        double verticalSpeed;
        double horizontalSpeed;
        if (player.method_21752()) {
            horizontalSpeed = glider.fastHorizontalSpeed;
            verticalSpeed = glider.fastVerticalSpeed;
        } else {
            horizontalSpeed = glider.horizontalSpeed;
            verticalSpeed = glider.verticalSpeed;
        }
        WindHelper.applyWind(player, stack);
        class_243 movement = player.method_18798();
        double deltaX = Math.cos(Math.toRadians(player.method_36454() + 90.0f)) * horizontalSpeed;
        double deltaZ = Math.sin(Math.toRadians(player.method_36454() + 90.0f)) * horizontalSpeed;
        player.method_18800(movement.field_1352 + deltaX, movement.field_1351 * verticalSpeed, movement.field_1350 + deltaZ);
        if (((ServerConfig)HangGlider.CONFIG.get(ServerConfig.class)).wind.allowAirResistance) {
            movement = player.method_18798();
            double airResistance = glider.airResistance;
            player.method_18800(movement.field_1352 * airResistance, movement.field_1351, movement.field_1350 * airResistance);
        }
        if (player.method_18798().field_1351 > -0.5) {
            player.field_6017 = 1.0;
        }
    }

    private static void handleGliderDurability(class_1657 player, class_1799 itemStack, ServerConfig.GliderConfig gliderMaterialSettings) {
        if (gliderMaterialSettings.consumeDurability && player.method_59922().method_43048(gliderMaterialSettings.durabilityUseInterval) == 0) {
            class_1304 equipmentSlot = PlayerGlidingHelper.getGliderHoldingHand(player);
            Objects.requireNonNull(equipmentSlot, "equipment slot is null");
            itemStack.method_7970(1, (class_1309)player, equipmentSlot);
        }
    }
}

