/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.justagreenhouse.block;

import java.util.function.Supplier;
import net.magicvt.justagreenhouse.block.FakeFence;
import net.magicvt.justagreenhouse.block.SeedMakerBlock;
import net.magicvt.justagreenhouse.item.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"justagreenhouse");
    public static final RegistryObject<Block> GREENHOUSE_GLASS = ModBlocks.registerBlock("greenhouse_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60918_(SoundType.f_56762_).m_60913_(2.0f, 3.0f)));
    public static final RegistryObject<Block> GREENHOUSE_PILLAR = ModBlocks.registerBlock("greenhouse_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(1.0f, 3.0f).m_60918_(SoundType.f_56762_)));
    public static final RegistryObject<Block> GREENHOUSE_BLOCK = ModBlocks.registerBlock("greenhouse_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(1.0f, 3.0f).m_60918_(SoundType.f_56762_)));
    public static final RegistryObject<Block> GREENHOUSE_STAIRS = ModBlocks.registerBlock("greenhouse_stairs", () -> new StairBlock(() -> ((Block)GREENHOUSE_BLOCK.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(1.0f, 3.0f).m_60918_(SoundType.f_56762_)));
    public static final RegistryObject<Block> GREENHOUSE_SLAB = ModBlocks.registerBlock("greenhouse_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60913_(1.0f, 3.0f).m_60918_(SoundType.f_56762_)));
    public static final RegistryObject<DoorBlock> GREENHOUSE_DOOR = ModBlocks.registerBlock("greenhouse_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_).m_60913_(1.0f, 3.0f).m_60955_().m_60918_(SoundType.f_56762_), BlockSetType.f_271512_));
    public static final RegistryObject<LanternBlock> GREENHOUSE_LANTERN = ModBlocks.registerBlock("greenhouse_lantern", () -> new LanternBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_).m_60918_(SoundType.f_56762_).m_60913_(1.0f, 3.0f)));
    public static final RegistryObject<Block> GREENHOUSE_POST = ModBlocks.registerBlock("greenhouse_post", () -> new FakeFence(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_60918_(SoundType.f_56762_).m_60910_()));
    public static final RegistryObject<Block> FLOOR_LANTERN = ModBlocks.registerBlock("floor_lantern", () -> new FakeFence(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_60918_(SoundType.f_56762_).m_60910_()));
    public static final RegistryObject<Block> WHEAT_SEED_BAG = ModBlocks.registerBlock("wheat_seed_bag", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> MELON_SEED_BAG = ModBlocks.registerBlock("melon_seed_bag", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> BEETROOT_SEED_BAG = ModBlocks.registerBlock("beetroot_seed_bag", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> PUMPKIN_SEED_BAG = ModBlocks.registerBlock("pumpkin_seed_bag", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> TORCHFLOWER_SEED_BAG = ModBlocks.registerBlock("torchflower_seed_bag", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> PITCHER_POD_BAG = ModBlocks.registerBlock("pitcher_pod_bag", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Block> SEED_MAKER = ModBlocks.registerBlock("seed_maker", () -> new SeedMakerBlock());

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

