/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.chunk;

import com.magicbroom.examplemod.core.AshenWitchBroom;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;

public class ChunkLoadingManager {
    private static final TicketType<ChunkPos> BROOM_WEAK_LOADING_TICKET = TicketType.create((String)"ashenwitchbroom_broom_weak", (a, b) -> Long.compare(a.toLong(), b.toLong()), (int)0);
    private static final Map<String, Map<ChunkPos, Boolean>> loadedChunks = new ConcurrentHashMap<String, Map<ChunkPos, Boolean>>();
    private static final ScheduledExecutorService chunkCheckExecutor = Executors.newScheduledThreadPool(2, r -> {
        Thread t = new Thread(r, "ChunkLoadingManager-AsyncChecker");
        t.setDaemon(true);
        return t;
    });
    private static ChunkLoadingManager instance;

    public static ChunkLoadingManager getInstance() {
        if (instance == null) {
            instance = new ChunkLoadingManager();
        }
        return instance;
    }

    public boolean addWeakLoadedChunk(ServerLevel level, int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        String dimensionKey = level.dimension().location().toString();
        try {
            level.getChunkSource().addRegionTicket(BROOM_WEAK_LOADING_TICKET, chunkPos, 0, (Object)chunkPos);
            loadedChunks.computeIfAbsent(dimensionKey, k -> new ConcurrentHashMap()).put(chunkPos, true);
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u4e3a\u626b\u5e1a {} \u5728\u7ef4\u5ea6 {} \u7684\u533a\u5757 ({}, {}) \u6dfb\u52a0\u52a0\u8f7d\u7968\u636e", chunkX, chunkZ, dimensionKey);
            return true;
        }
        catch (Exception e) {
            AshenWitchBroom.WRAPPED_LOGGER.error("\u6dfb\u52a0\u5f31\u52a0\u8f7d\u533a\u5757\u5931\u8d25\uff1a({}, {}) \u5728\u7ef4\u5ea6 {}\uff1a{}", chunkX, chunkZ, dimensionKey, e.getMessage());
            return false;
        }
    }

    public boolean removeWeakLoadedChunk(ServerLevel level, int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        String dimensionKey = level.dimension().location().toString();
        Map<ChunkPos, Boolean> dimensionChunks = loadedChunks.get(dimensionKey);
        if (dimensionChunks == null || !dimensionChunks.containsKey(chunkPos)) {
            return false;
        }
        try {
            level.getChunkSource().removeRegionTicket(BROOM_WEAK_LOADING_TICKET, chunkPos, 0, (Object)chunkPos);
            dimensionChunks.remove(chunkPos);
            if (dimensionChunks.isEmpty()) {
                loadedChunks.remove(dimensionKey);
            }
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u4e3a\u626b\u5e1a {} \u5728\u7ef4\u5ea6 {} \u7684\u533a\u5757 ({}, {}) \u79fb\u9664\u52a0\u8f7d\u7968\u636e", chunkX, chunkZ, dimensionKey);
            return true;
        }
        catch (Exception e) {
            AshenWitchBroom.WRAPPED_LOGGER.error("\u79fb\u9664\u5f31\u52a0\u8f7d\u533a\u5757\u5931\u8d25\uff1a({}, {}) \u5728\u7ef4\u5ea6 {}\uff1a{}", chunkX, chunkZ, dimensionKey, e.getMessage());
            return false;
        }
    }

    public boolean isChunkLoadedByManager(ServerLevel level, int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        String dimensionKey = level.dimension().location().toString();
        Map<ChunkPos, Boolean> dimensionChunks = loadedChunks.get(dimensionKey);
        return dimensionChunks != null && dimensionChunks.containsKey(chunkPos);
    }

    public Map<ChunkPos, Boolean> getLoadedChunksInDimension(ServerLevel level) {
        String dimensionKey = level.dimension().location().toString();
        return loadedChunks.getOrDefault(dimensionKey, new ConcurrentHashMap());
    }

    public boolean hasChunk(ServerLevel level, int chunkX, int chunkZ) {
        try {
            ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
            boolean isEntityTicking = level.areEntitiesLoaded(chunkPos.toLong());
            return isEntityTicking;
        }
        catch (Exception e) {
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u68c0\u67e5\u5931\u8d25: {}", chunkX, chunkZ, level.dimension().location().toString(), e.getMessage());
            return false;
        }
    }

    public CompletableFuture<Boolean> waitForChunkLoadedAsync(ServerLevel level, int chunkX, int chunkZ, Consumer<Boolean> onChunkLoaded, int timeoutSeconds) {
        return CompletableFuture.supplyAsync(() -> {
            String dimensionKey = level.dimension().location().toString();
            long startTime = System.currentTimeMillis();
            long timeoutMs = (long)timeoutSeconds * 1000L;
            int checkCount = 0;
            try {
                while (System.currentTimeMillis() - startTime < timeoutMs) {
                    ++checkCount;
                    if (this.hasChunk(level, chunkX, chunkZ)) {
                        long elapsedTime = System.currentTimeMillis() - startTime;
                        AshenWitchBroom.WRAPPED_LOGGER.debug("\u533a\u5757\u52a0\u8f7d\u5b8c\u6210: ({}, {}) \u5728\u7ef4\u5ea6 {}, \u8017\u65f6: {}ms, \u68c0\u6d4b\u6b21\u6570: {}", chunkX, chunkZ, dimensionKey, elapsedTime, checkCount);
                        return true;
                    }
                    Thread.sleep(50L);
                }
                AshenWitchBroom.WRAPPED_LOGGER.warn("\u533a\u5757\u52a0\u8f7d\u8d85\u65f6: ({}, {}) \u5728\u7ef4\u5ea6 {}, \u8d85\u65f6\u65f6\u95f4: {}\u79d2, \u603b\u68c0\u6d4b\u6b21\u6570: {}", chunkX, chunkZ, dimensionKey, timeoutSeconds, checkCount);
                return false;
            }
            catch (InterruptedException e) {
                AshenWitchBroom.WRAPPED_LOGGER.warn("\u533a\u5757\u52a0\u8f7d\u7b49\u5f85\u88ab\u4e2d\u65ad: ({}, {}) \u5728\u7ef4\u5ea6 {}, \u68c0\u6d4b\u6b21\u6570: {}", chunkX, chunkZ, dimensionKey, checkCount);
                Thread.currentThread().interrupt();
                return false;
            }
        }, chunkCheckExecutor).whenComplete((result, throwable) -> level.getServer().execute(() -> {
            if (throwable != null) {
                AshenWitchBroom.WRAPPED_LOGGER.error("\u5f02\u6b65\u533a\u5757\u52a0\u8f7d\u68c0\u6d4b\u51fa\u9519: ({}, {}) \u5728\u7ef4\u5ea6 {}: {}", chunkX, chunkZ, level.dimension().location().toString(), throwable.getMessage());
                onChunkLoaded.accept(false);
            } else {
                onChunkLoaded.accept((Boolean)result);
            }
        }));
    }

    public CompletableFuture<Boolean> addWeakLoadedChunkAsync(ServerLevel level, int chunkX, int chunkZ, Consumer<Boolean> onChunkLoaded, int timeoutSeconds) {
        boolean addResult = this.addWeakLoadedChunk(level, chunkX, chunkZ);
        if (!addResult) {
            AshenWitchBroom.WRAPPED_LOGGER.error("\u6dfb\u52a0\u5f31\u52a0\u8f7d\u533a\u5757\u5931\u8d25: ({}, {}) \u5728\u7ef4\u5ea6 {}", chunkX, chunkZ, level.dimension().location().toString());
            onChunkLoaded.accept(false);
            return CompletableFuture.completedFuture(false);
        }
        return this.waitForChunkLoadedAsync(level, chunkX, chunkZ, onChunkLoaded, timeoutSeconds);
    }

    public CompletableFuture<Boolean> addWeakLoadedChunkAsync(ServerLevel level, int chunkX, int chunkZ, Consumer<Boolean> onChunkLoaded) {
        return this.addWeakLoadedChunkAsync(level, chunkX, chunkZ, onChunkLoaded, 10);
    }

    public void clearAllLoadedChunks() {
        int totalTickets = 0;
        for (Map<ChunkPos, Boolean> chunks : loadedChunks.values()) {
            totalTickets += chunks.size();
        }
        loadedChunks.clear();
        AshenWitchBroom.WRAPPED_LOGGER.debug("\u6e05\u7406\u6240\u6709\u626b\u5e1a\u7684\u533a\u5757\u52a0\u8f7d\u7968\u636e\uff0c\u5171\u6e05\u7406 {} \u4e2a\u7968\u636e", totalTickets);
    }

    public void shutdown() {
        chunkCheckExecutor.shutdown();
        try {
            if (!chunkCheckExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                chunkCheckExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            chunkCheckExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        AshenWitchBroom.WRAPPED_LOGGER.debug("ChunkLoadingManager\u6267\u884c\u5668\u5173\u95ed\u5b8c\u6210");
    }

    public Map<String, Map<ChunkPos, Boolean>> getAllLoadedChunks() {
        return new ConcurrentHashMap<String, Map<ChunkPos, Boolean>>(loadedChunks);
    }
}

