/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.client;

import com.magicbroom.examplemod.client.ClientHandler;
import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.item.MajoHatItem;
import com.magicbroom.examplemod.model.MajoBroomModel;
import com.magicbroom.examplemod.model.MajoClothModel;
import com.magicbroom.examplemod.model.MajoHatModel;
import com.magicbroom.examplemod.network.SummonBroomPack;
import com.magicbroom.examplemod.render.MajoBroomEntityRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod(value="ashenwitchbroom", dist={Dist.CLIENT})
@EventBusSubscriber(modid="ashenwitchbroom", value={Dist.CLIENT})
public class AshenWitchBroomClient {
    public AshenWitchBroomClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        AshenWitchBroomClient.init();
    }

    public static void init() {
        NeoForge.EVENT_BUS.register(ClientHandler.class);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        AshenWitchBroom.WRAPPED_LOGGER.debug("\u5ba2\u6237\u7aef\u8bbe\u7f6e\u521d\u59cb\u5316\u5b8c\u6210");
        AshenWitchBroom.WRAPPED_LOGGER.debug("Minecraft \u7528\u6237\u540d >> {}", Minecraft.getInstance().getUser().getName());
    }

    @SubscribeEvent
    static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(MajoHatModel.LAYER_LOCATION, MajoHatModel::createBodyLayer);
        event.registerLayerDefinition(MajoClothModel.LAYER_LOCATION, MajoClothModel::createBodyLayer);
        event.registerLayerDefinition(MajoBroomModel.LAYER_LOCATION, MajoBroomModel::createBodyLayer);
    }

    @SubscribeEvent
    static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AshenWitchBroom.MAJO_BROOM_ENTITY.get(), MajoBroomEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex == 0 ? ((MajoHatItem)stack.getItem()).getColor(stack) : -1, new ItemLike[]{(ItemLike)AshenWitchBroom.MAJO_HAT.get()});
    }

    public static void sendSummonBroomPacket(double x, double y, double z) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SummonBroomPack(x, y, z), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

