/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.client;

import com.magicbroom.examplemod.client.AshenWitchBroomClient;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

@EventBusSubscriber(modid="ashenwitchbroom", value={Dist.CLIENT})
public class KeyBoardInput {
    public static final KeyMapping UP_KEY = new KeyMapping("key.up", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 32, "key.category.majobroom");
    public static final KeyMapping DOWN_KEY = new KeyMapping("key.down", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 342, "key.category.majobroom");
    public static final KeyMapping SUMMON_KEY = new KeyMapping("key.summon", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 82, "key.category.majobroom");
    public static final KeyMapping SPEED_BOOST_KEY = new KeyMapping("key.speed_boost", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 341, "key.category.majobroom");
    public static boolean up = false;
    public static boolean down = false;
    public static boolean speedBoost = false;

    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(UP_KEY);
        event.register(DOWN_KEY);
        event.register(SUMMON_KEY);
        event.register(SPEED_BOOST_KEY);
    }

    @SubscribeEvent
    public static void onKeyboardInput(InputEvent.Key event) {
        if (UP_KEY.getKey().getValue() == event.getKey()) {
            if (event.getAction() == 1) {
                up = true;
            } else if (event.getAction() == 0) {
                up = false;
            }
        }
        if (DOWN_KEY.getKey().getValue() == event.getKey()) {
            if (event.getAction() == 1) {
                down = true;
            } else if (event.getAction() == 0) {
                down = false;
            }
        }
        if (SUMMON_KEY.getKey().getValue() == event.getKey() && event.getAction() == 1) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.player != null && minecraft.screen == null) {
                Vec3 pos = minecraft.player.position();
                AshenWitchBroomClient.sendSummonBroomPacket(pos.x, pos.y, pos.z);
            }
        }
        if (SPEED_BOOST_KEY.getKey().getValue() == event.getKey()) {
            if (event.getAction() == 1) {
                speedBoost = true;
            } else if (event.getAction() == 0) {
                speedBoost = false;
            }
        }
    }

    public static KeyMapping[] getKeyMappings() {
        return new KeyMapping[]{UP_KEY, DOWN_KEY, SUMMON_KEY, SPEED_BOOST_KEY};
    }
}

