/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.command;

import com.magicbroom.examplemod.chunk.BroomChunkTicketManager;
import com.magicbroom.examplemod.chunk.ChunkLoadingManager;
import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.core.Config;
import com.magicbroom.examplemod.data.BroomData;
import com.magicbroom.examplemod.data.BroomDataManager;
import com.magicbroom.examplemod.entity.MajoBroomEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class BroomCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"broom").then(((LiteralArgumentBuilder)Commands.literal((String)"detect").executes(BroomCommand::executeDetect)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(BroomCommand::executeDetectPlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"stats").executes(BroomCommand::executeStats)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(BroomCommand::executeStatsPlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"cleanup").executes(BroomCommand::executeCleanup)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(BroomCommand::executeCleanupPlayer)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"chunks").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.literal((String)"lazy").then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(BroomCommand::executeChunksAddLazy)).then(Commands.argument((String)"w", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"h", (ArgumentType)IntegerArgumentType.integer()).executes(BroomCommand::executeChunksAddLazy))))))).then(Commands.literal((String)"ticking").then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(BroomCommand::executeChunksAddTicking)).then(Commands.argument((String)"w", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"h", (ArgumentType)IntegerArgumentType.integer()).executes(BroomCommand::executeChunksAddTicking)))))))).then(Commands.literal((String)"del").then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(BroomCommand::executeChunksDel)).then(Commands.argument((String)"w", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"h", (ArgumentType)IntegerArgumentType.integer()).executes(BroomCommand::executeChunksDel))))))).then(Commands.literal((String)"list").executes(BroomCommand::executeChunksList))).then(Commands.literal((String)"help").executes(BroomCommand::executeChunksHelp)))).then(Commands.literal((String)"help").executes(BroomCommand::executeHelp))).executes(BroomCommand::executeHelp));
    }

    private static int executeDetect(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return BroomCommand.executeDetectForPlayer(source, player);
        }
        source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.broom.detect.player_only"));
        return 0;
    }

    private static int executeDetectPlayer(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
            return BroomCommand.executeDetectForPlayer(source, targetPlayer);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.translatable((String)"commands.broom.detect.player_not_found"));
            return 0;
        }
    }

    private static int executeDetectForPlayer(CommandSourceStack source, ServerPlayer player) {
        UUID playerUUID;
        ServerLevel level = player.serverLevel();
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID = player.getUUID());
        if (brooms.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.result_title"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.player_info", (Object[])new Object[]{player.getDisplayName().getString()}), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.no_brooms_status"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
            return 1;
        }
        ArrayList<BroomDetectionResult> detectionResults = new ArrayList<BroomDetectionResult>();
        AtomicInteger completedDetections = new AtomicInteger(0);
        for (int i = 0; i < brooms.size(); ++i) {
            BroomData broom = brooms.get(i);
            BroomDetectionResult result = new BroomDetectionResult(i + 1, broom, level, player);
            detectionResults.add(result);
        }
        for (BroomDetectionResult result : detectionResults) {
            BroomCommand.detectBroomStatus(result, player, () -> {
                int completed = completedDetections.incrementAndGet();
                if (completed == brooms.size()) {
                    BroomCommand.outputDetectionResults(source, player, detectionResults);
                }
            });
        }
        return 1;
    }

    private static void detectBroomStatus(BroomDetectionResult result, ServerPlayer player, Runnable onComplete) {
        UUID entityUUID = result.broomData.getEntityUUID();
        if (entityUUID == null) {
            result.statusKey = "command.ashenwitchbroom.broom.detect.status_no_uuid";
            onComplete.run();
            return;
        }
        ServerLevel targetLevel = player.getServer().getLevel(result.broomData.getDimension());
        if (targetLevel == null) {
            result.statusKey = "command.ashenwitchbroom.broom.detect.status_invalid_dimension";
            onComplete.run();
            return;
        }
        BlockPos broomPos = result.broomData.getPosition();
        ChunkPos broomChunk = new ChunkPos(broomPos);
        AshenWitchBroom.WRAPPED_LOGGER.debug("BroomCommand(detect) - \u626b\u5e1a\u68c0\u6d4b\u5750\u6807\u8f6c\u6362: \u539f\u59cb\u5750\u6807 BlockPos({}, {}, {}) -> \u533a\u5757\u5750\u6807 ChunkPos({}, {})", broomPos.getX(), broomPos.getY(), broomPos.getZ(), broomChunk.x, broomChunk.z);
        ChunkLoadingManager.getInstance().addWeakLoadedChunkAsync(targetLevel, broomChunk.x, broomChunk.z, chunkLoaded -> {
            try {
                if (chunkLoaded.booleanValue()) {
                    AshenWitchBroom.WRAPPED_LOGGER.debug("BroomCommand(detect) - \u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u5df2\u6210\u529f\u52a0\u8f7d", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                    Entity entity = targetLevel.getEntity(entityUUID);
                    if (entity instanceof MajoBroomEntity) {
                        MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
                        result.statusKey = result.broomData.getBroomName().equals(broomEntity.getBroomName()) && player.getUUID().equals(broomEntity.getOwnerUUID()) ? "command.ashenwitchbroom.broom.detect.status_valid" : "command.ashenwitchbroom.broom.detect.status_mismatch";
                    } else {
                        result.statusKey = "command.ashenwitchbroom.broom.detect.status_invalid_entity";
                    }
                } else {
                    AshenWitchBroom.WRAPPED_LOGGER.warn("BroomCommand(detect) - \u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u52a0\u8f7d\u8d85\u65f6", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                    result.statusKey = "command.ashenwitchbroom.broom.detect.status_chunk_timeout";
                }
                ChunkLoadingManager.getInstance().removeWeakLoadedChunk(targetLevel, broomChunk.x, broomChunk.z);
            }
            catch (Throwable throwable) {
                ChunkLoadingManager.getInstance().removeWeakLoadedChunk(targetLevel, broomChunk.x, broomChunk.z);
                AshenWitchBroom.WRAPPED_LOGGER.debug("BroomCommand(detect) - \u5df2\u6e05\u7406\u68c0\u6d4b\u7528\u7684\u5f31\u52a0\u8f7d\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {}", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                onComplete.run();
                throw throwable;
            }
            AshenWitchBroom.WRAPPED_LOGGER.debug("BroomCommand(detect) - \u5df2\u6e05\u7406\u68c0\u6d4b\u7528\u7684\u5f31\u52a0\u8f7d\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {}", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
            onComplete.run();
        });
    }

    private static void outputDetectionResults(CommandSourceStack source, ServerPlayer player, List<BroomDetectionResult> results) {
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.result_title"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        ChatFormatting broomCountColor = results.size() > 10 ? ChatFormatting.GREEN : (results.size() > 5 ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
        MutableComponent broomCountComponent = Component.literal((String)String.valueOf(results.size())).withStyle(broomCountColor);
        source.sendSuccess(() -> BroomCommand.lambda$outputDetectionResults$13(player, (Component)broomCountComponent), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        for (int i = 0; i < results.size(); ++i) {
            BroomDetectionResult result = results.get(i);
            BroomData broom = result.broomData;
            MutableComponent indexComponent = Component.literal((String)String.valueOf(result.index)).withStyle(ChatFormatting.YELLOW);
            source.sendSuccess(() -> BroomCommand.lambda$outputDetectionResults$15((Component)indexComponent, broom), false);
            BlockPos pos = broom.getPosition();
            String dimensionName = broom.getDimension().location().toString();
            String formattedDimension = BroomCommand.formatDimensionName(dimensionName);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.position", (Object[])new Object[]{formattedDimension, pos.getX(), pos.getY(), pos.getZ()}), false);
            UUID entityUUID = broom.getEntityUUID();
            if (entityUUID != null) {
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.entity_uuid", (Object[])new Object[]{entityUUID.toString()}), false);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.entity_missing"), false);
            }
            source.sendSuccess(() -> Component.translatable((String)result.statusKey), false);
            if (broom.getDimension().equals((Object)result.level.dimension())) {
                double distance = Math.sqrt(broom.getDistanceSquared(player.blockPosition(), (ResourceKey<Level>)result.level.dimension()));
                ChatFormatting distanceColor = distance <= 50.0 ? ChatFormatting.GREEN : (distance <= 200.0 ? ChatFormatting.YELLOW : ChatFormatting.RED);
                String formattedDistance = String.format("%.2f", distance);
                MutableComponent distanceComponent = Component.literal((String)formattedDistance).withStyle(distanceColor);
                source.sendSuccess(() -> BroomCommand.lambda$outputDetectionResults$20((Component)distanceComponent), false);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.distance_cross_dimension"), false);
            }
            if (i >= results.size() - 1) continue;
            source.sendSuccess(() -> Component.literal((String)""), false);
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
    }

    private static int executeStats(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return BroomCommand.executeStatsForPlayer(source, player);
        }
        source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.broom.stats.player_only"));
        return 0;
    }

    private static int executeStatsPlayer(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
            return BroomCommand.executeStatsForPlayer(source, targetPlayer);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.translatable((String)"commands.broom.stats.player_not_found"));
            return 0;
        }
    }

    private static int executeStatsForPlayer(CommandSourceStack source, ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, player.getUUID());
        int storedBrooms = brooms.size();
        int inventoryBrooms = 0;
        for (ItemStack itemStack : player.getInventory().items) {
            if (itemStack.getItem() != AshenWitchBroom.MAJO_BROOM_ITEM.get()) continue;
            inventoryBrooms += itemStack.getCount();
        }
        int finalInventoryBrooms = inventoryBrooms;
        int totalBrooms = storedBrooms + inventoryBrooms;
        ResourceKey currentDimension = player.level().dimension();
        long currentDimensionBrooms = brooms.stream().filter(broom -> broom.getDimension().equals((Object)currentDimension)).count();
        int nearbyRange = (Integer)Config.NEARBY_SEARCH_RANGE.get();
        BlockPos playerPos = player.blockPosition();
        long nearbyBrooms = brooms.stream().filter(broom -> broom.getDimension().equals((Object)currentDimension)).filter(broom -> broom.getDistanceSquared(playerPos, (ResourceKey<Level>)currentDimension) <= (double)(nearbyRange * nearbyRange)).count();
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.stats.title"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.player_info", (Object[])new Object[]{player.getDisplayName().getString()}), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.stats.count_section"), false);
        ChatFormatting totalColor = totalBrooms > 10 ? ChatFormatting.GREEN : (totalBrooms > 5 ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
        MutableComponent totalComponent = Component.literal((String)String.valueOf(totalBrooms)).withStyle(totalColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$33((Component)totalComponent), false);
        ChatFormatting inventoryColor = finalInventoryBrooms > 0 ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        MutableComponent inventoryComponent = Component.literal((String)String.valueOf(finalInventoryBrooms)).withStyle(inventoryColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$34((Component)inventoryComponent), false);
        ChatFormatting nearbyColor = nearbyBrooms > 0L ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        MutableComponent nearbyComponent = Component.literal((String)String.valueOf(nearbyBrooms)).withStyle(nearbyColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$35(nearbyRange, (Component)nearbyComponent), false);
        ChatFormatting currentWorldColor = currentDimensionBrooms > 0L ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        String dimensionName = BroomCommand.formatDimensionName(currentDimension.location().toString());
        MutableComponent currentDimensionComponent = Component.literal((String)String.valueOf(currentDimensionBrooms)).withStyle(currentWorldColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$36(dimensionName, (Component)currentDimensionComponent), false);
        ChatFormatting storedColor = storedBrooms > 0 ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        MutableComponent storedComponent = Component.literal((String)String.valueOf(storedBrooms)).withStyle(storedColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$37((Component)storedComponent), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.stats.summon_section"), false);
        MutableComponent nearbyStatus = (Boolean)Config.ENABLE_NEARBY_SUMMON.get() != false ? Component.translatable((String)"command.ashenwitchbroom.broom.stats.enabled") : Component.translatable((String)"command.ashenwitchbroom.broom.stats.disabled");
        MutableComponent worldStatus = (Boolean)Config.ENABLE_WORLD_SUMMON.get() != false ? Component.translatable((String)"command.ashenwitchbroom.broom.stats.enabled") : Component.translatable((String)"command.ashenwitchbroom.broom.stats.disabled");
        MutableComponent crossDimensionStatus = (Boolean)Config.ENABLE_CROSS_DIMENSION_SUMMON.get() != false ? Component.translatable((String)"command.ashenwitchbroom.broom.stats.enabled") : Component.translatable((String)"command.ashenwitchbroom.broom.stats.disabled");
        MutableComponent inventoryStatus = (Boolean)Config.ENABLE_INVENTORY_SUMMON.get() != false ? Component.translatable((String)"command.ashenwitchbroom.broom.stats.enabled") : Component.translatable((String)"command.ashenwitchbroom.broom.stats.disabled");
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$40((Component)nearbyStatus), false);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$41((Component)worldStatus), false);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$42((Component)crossDimensionStatus), false);
        source.sendSuccess(() -> BroomCommand.lambda$executeStatsForPlayer$43((Component)inventoryStatus), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        return 1;
    }

    private static int executeCleanup(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return BroomCommand.executeCleanupForPlayer(source, player);
        }
        source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.player_only"));
        return 0;
    }

    private static int executeCleanupPlayer(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            ServerPlayer targetPlayer = EntityArgument.getPlayer(context, (String)"player");
            return BroomCommand.executeCleanupForPlayer(source, targetPlayer);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.translatable((String)"commands.broom.cleanup.player_not_found"));
            return 0;
        }
    }

    private static int executeCleanupForPlayer(CommandSourceStack source, ServerPlayer player) {
        UUID playerUUID;
        ServerLevel level = player.serverLevel();
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID = player.getUUID());
        if (brooms.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.result_title"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.player_info", (Object[])new Object[]{player.getDisplayName().getString()}), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.no_brooms_status"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
            return 1;
        }
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.progress_title"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        ChatFormatting broomCountColor = brooms.size() > 10 ? ChatFormatting.GREEN : (brooms.size() > 5 ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
        MutableComponent broomCountComponent = Component.literal((String)String.valueOf(brooms.size())).withStyle(broomCountColor);
        source.sendSuccess(() -> BroomCommand.lambda$executeCleanupForPlayer$53(player, (Component)broomCountComponent), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.start_verify"), false);
        ArrayList<BroomCleanupResult> cleanupResults = new ArrayList<BroomCleanupResult>();
        AtomicInteger completedVerifications = new AtomicInteger(0);
        for (int i = 0; i < brooms.size(); ++i) {
            BroomData broom = brooms.get(i);
            BroomCleanupResult result = new BroomCleanupResult(i + 1, broom);
            cleanupResults.add(result);
        }
        for (BroomCleanupResult result : cleanupResults) {
            BroomCommand.verifyBroomForCleanup(result, player, () -> {
                int completed = completedVerifications.incrementAndGet();
                if (completed == brooms.size()) {
                    BroomCommand.processCleanupResults(source, player, cleanupResults);
                }
            });
        }
        return 1;
    }

    private static void verifyBroomForCleanup(BroomCleanupResult result, ServerPlayer player, Runnable onComplete) {
        UUID entityUUID = result.broomData.getEntityUUID();
        if (entityUUID == null) {
            result.isValid = false;
            result.verificationComplete = true;
            onComplete.run();
            return;
        }
        ServerLevel targetLevel = player.getServer().getLevel(result.broomData.getDimension());
        if (targetLevel == null) {
            result.isValid = false;
            result.verificationComplete = true;
            onComplete.run();
            return;
        }
        BlockPos broomPos = result.broomData.getPosition();
        ChunkPos broomChunk = new ChunkPos(broomPos);
        AshenWitchBroom.WRAPPED_LOGGER.debug("BroomCommand(cleanup) - \u626b\u5e1a\u9a8c\u8bc1\u5750\u6807\u8f6c\u6362: \u539f\u59cb\u5750\u6807 BlockPos({}, {}, {}) -> \u533a\u5757\u5750\u6807 ChunkPos({}, {})", broomPos.getX(), broomPos.getY(), broomPos.getZ(), broomChunk.x, broomChunk.z);
        ChunkLoadingManager.getInstance().addWeakLoadedChunkAsync(targetLevel, broomChunk.x, broomChunk.z, chunkLoaded -> {
            try {
                if (chunkLoaded.booleanValue()) {
                    AshenWitchBroom.WRAPPED_LOGGER.debug("BroomCommand(cleanup) - \u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u5df2\u6210\u529f\u52a0\u8f7d", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                    Entity entity = targetLevel.getEntity(entityUUID);
                    if (entity instanceof MajoBroomEntity) {
                        MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
                        result.isValid = result.broomData.getBroomName().equals(broomEntity.getBroomName()) && player.getUUID().equals(broomEntity.getOwnerUUID());
                    } else {
                        result.isValid = false;
                    }
                } else {
                    AshenWitchBroom.WRAPPED_LOGGER.warn("BroomCommand(cleanup) - \u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u52a0\u8f7d\u8d85\u65f6", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                    result.isValid = false;
                }
                ChunkLoadingManager.getInstance().removeWeakLoadedChunk(targetLevel, broomChunk.x, broomChunk.z);
            }
            catch (Throwable throwable) {
                ChunkLoadingManager.getInstance().removeWeakLoadedChunk(targetLevel, broomChunk.x, broomChunk.z);
                AshenWitchBroom.WRAPPED_LOGGER.debug("BroomCommand(cleanup) - \u5df2\u6e05\u7406\u9a8c\u8bc1\u7528\u7684\u5f31\u52a0\u8f7d\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {}", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                result.verificationComplete = true;
                onComplete.run();
                throw throwable;
            }
            AshenWitchBroom.WRAPPED_LOGGER.debug("BroomCommand(cleanup) - \u5df2\u6e05\u7406\u9a8c\u8bc1\u7528\u7684\u5f31\u52a0\u8f7d\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {}", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
            result.verificationComplete = true;
            onComplete.run();
        });
    }

    private static void processCleanupResults(CommandSourceStack source, ServerPlayer player, List<BroomCleanupResult> results) {
        ServerLevel level = player.serverLevel();
        UUID playerUUID = player.getUUID();
        int removedCount = 0;
        ArrayList<String> removedBrooms = new ArrayList<String>();
        for (BroomCleanupResult result : results) {
            if (!result.isValid) {
                boolean removed = BroomCommand.removeBroomByUUID(level, playerUUID, result.broomData);
                if (!removed) continue;
                ++removedCount;
                removedBrooms.add(result.broomData.getBroomName());
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.invalid_removed", (Object[])new Object[]{result.broomData.getBroomName()}), false);
                continue;
            }
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.valid", (Object[])new Object[]{result.broomData.getBroomName()}), false);
        }
        int totalCount = results.size();
        int remaining = totalCount - removedCount;
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.result_section"), false);
        ChatFormatting totalColor = totalCount > 10 ? ChatFormatting.GREEN : (totalCount > 5 ? ChatFormatting.YELLOW : ChatFormatting.WHITE);
        MutableComponent totalComponent = Component.literal((String)String.valueOf(totalCount)).withStyle(totalColor);
        source.sendSuccess(() -> BroomCommand.lambda$processCleanupResults$62((Component)totalComponent), false);
        ChatFormatting validColor = remaining > 0 ? ChatFormatting.GREEN : ChatFormatting.GRAY;
        MutableComponent validComponent = Component.literal((String)String.valueOf(remaining)).withStyle(validColor);
        source.sendSuccess(() -> BroomCommand.lambda$processCleanupResults$63((Component)validComponent), false);
        ChatFormatting removedColor = removedCount > 0 ? ChatFormatting.RED : ChatFormatting.GRAY;
        MutableComponent removedComponent = Component.literal((String)String.valueOf(removedCount)).withStyle(removedColor);
        source.sendSuccess(() -> BroomCommand.lambda$processCleanupResults$64((Component)removedComponent), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        if (removedCount > 0) {
            MutableComponent removedCountComponent = Component.literal((String)String.valueOf(removedCount)).withStyle(ChatFormatting.RED);
            source.sendSuccess(() -> BroomCommand.lambda$processCleanupResults$66((Component)removedCountComponent), false);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.success_all_valid"), false);
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
    }

    private static CompletableFuture<Boolean> verifyBroomExistsByUUID(ServerPlayer player, BroomData broomData) {
        if (broomData.getEntityUUID() == null) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            ServerLevel targetLevel = player.getServer().getLevel(broomData.getDimension());
            if (targetLevel == null) {
                return CompletableFuture.completedFuture(false);
            }
            BlockPos broomPos = broomData.getPosition();
            ChunkPos broomChunk = new ChunkPos(broomPos);
            AshenWitchBroom.WRAPPED_LOGGER.debug("BroomCommand - \u626b\u5e1a\u9a8c\u8bc1\u5750\u6807\u8f6c\u6362: \u539f\u59cb\u5750\u6807 BlockPos({}, {}, {}) -> \u533a\u5757\u5750\u6807 ChunkPos({}, {})", broomPos.getX(), broomPos.getY(), broomPos.getZ(), broomChunk.x, broomChunk.z);
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            ChunkLoadingManager.getInstance().addWeakLoadedChunkAsync(targetLevel, broomChunk.x, broomChunk.z, chunkLoaded -> {
                try {
                    if (chunkLoaded.booleanValue()) {
                        AshenWitchBroom.WRAPPED_LOGGER.debug("BroomCommand - \u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u5df2\u6210\u529f\u52a0\u8f7d\u7528\u4e8e\u9a8c\u8bc1", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                        Entity entity = targetLevel.getEntity(broomData.getEntityUUID());
                        if (entity instanceof MajoBroomEntity) {
                            MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
                            boolean result = broomData.getBroomName().equals(broomEntity.getBroomName()) && player.getUUID().equals(broomEntity.getOwnerUUID());
                            future.complete(result);
                        } else {
                            future.complete(false);
                        }
                    } else {
                        AshenWitchBroom.WRAPPED_LOGGER.warn("BroomCommand - \u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} \u52a0\u8f7d\u8d85\u65f6\uff0c\u9a8c\u8bc1\u5931\u8d25", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                        future.complete(false);
                    }
                    ChunkLoadingManager.getInstance().removeWeakLoadedChunk(targetLevel, broomChunk.x, broomChunk.z);
                }
                catch (Throwable throwable) {
                    ChunkLoadingManager.getInstance().removeWeakLoadedChunk(targetLevel, broomChunk.x, broomChunk.z);
                    AshenWitchBroom.WRAPPED_LOGGER.debug("\u5df2\u6e05\u7406\u4e34\u65f6\u5f31\u52a0\u8f7d\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} - verifyBroomExistsByUUID", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
                    throw throwable;
                }
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u5df2\u6e05\u7406\u4e34\u65f6\u5f31\u52a0\u8f7d\u533a\u5757 ({}, {}) \u5728\u7ef4\u5ea6 {} - verifyBroomExistsByUUID", broomChunk.x, broomChunk.z, targetLevel.dimension().location());
            });
            return future;
        }
        catch (Exception e) {
            AshenWitchBroom.WRAPPED_LOGGER.warn("\u9a8c\u8bc1\u626b\u5e1a\u5b58\u5728\u6027\u65f6\u53d1\u751f\u9519\u8bef\uff1a{}", e.getMessage());
            return CompletableFuture.completedFuture(false);
        }
    }

    private static boolean removeBroomByUUID(ServerLevel level, UUID playerUUID, BroomData broomToRemove) {
        List<BroomData> brooms = BroomDataManager.loadPlayerBrooms(level, playerUUID);
        boolean removed = brooms.removeIf(broom -> broom.getBroomName().equals(broomToRemove.getBroomName()) && broom.getEntityUUID() != null && broom.getEntityUUID().equals(broomToRemove.getEntityUUID()));
        if (removed) {
            BroomDataManager.savePlayerBrooms(level, playerUUID, brooms);
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u4e3a\u73a9\u5bb6 {} \u79fb\u9664\u4e86\u626b\u5e1a '{}' (UUID: {})", playerUUID, broomToRemove.getBroomName(), broomToRemove.getEntityUUID());
        }
        return removed;
    }

    private static int executeHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        boolean isOp = source.hasPermission(2);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.title"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.player_commands"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.detect_self"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.stats_self"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.cleanup_self"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.help_command"), false);
        if (isOp) {
            source.sendSuccess(() -> Component.literal((String)""), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.admin_commands"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.detect_player"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.stats_player"), false);
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.cleanup_player"), false);
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.usage_tips"), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.tip_self_manage"), false);
        if (!isOp) {
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.tip_op_required"), false);
        }
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.help.tip_cleanup"), false);
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.broom.detect.separator"), false);
        return 1;
    }

    private static String formatDimensionName(String dimensionName) {
        if (dimensionName == null || dimensionName.isEmpty()) {
            return "unknown";
        }
        if (dimensionName.equals("minecraft:overworld")) {
            return "overworld";
        }
        if (dimensionName.equals("minecraft:the_nether")) {
            return "the nether";
        }
        if (dimensionName.equals("minecraft:the_end")) {
            return "the end";
        }
        if (dimensionName.startsWith("minecraft:")) {
            return dimensionName.substring(10).replace("_", " ");
        }
        int colonIndex = dimensionName.indexOf(58);
        if (colonIndex > 0 && colonIndex < dimensionName.length() - 1) {
            String namespace = dimensionName.substring(0, colonIndex);
            String path = dimensionName.substring(colonIndex + 1);
            return namespace + ": " + path.replace("_", " ");
        }
        return dimensionName.replace("_", " ");
    }

    private static int executeChunksAddLazy(CommandContext<CommandSourceStack> context) {
        try {
            ChunkPos chunk;
            int[] args;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            int x = IntegerArgumentType.getInteger(context, (String)"x");
            int z = IntegerArgumentType.getInteger(context, (String)"z");
            try {
                int w = IntegerArgumentType.getInteger(context, (String)"w");
                int h = IntegerArgumentType.getInteger(context, (String)"h");
                args = new int[]{x, z, w, h};
            }
            catch (IllegalArgumentException e) {
                args = new int[]{x, z};
            }
            ServerLevel level = source.getLevel();
            String dimensionName = level.dimension().location().toString();
            List<ChunkPos> chunks = BroomChunkTicketManager.parseCoordinateArgs(args);
            if (chunks.isEmpty()) {
                source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.lazy.invalid_coordinates").withStyle(ChatFormatting.RED));
                return 0;
            }
            BroomChunkTicketManager.BatchOperationResult result = BroomChunkTicketManager.getInstance().addLazyLoadedChunksBatch(level, chunks);
            if (result.getSuccessCount() > 0) {
                if (result.getSuccessCount() == 1) {
                    chunk = result.getSuccessChunks().get(0);
                    source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.add.lazy.success", (Object[])new Object[]{chunk.x, chunk.z, dimensionName}).withStyle(ChatFormatting.GREEN), true);
                } else {
                    source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.add.lazy.batch_success", (Object[])new Object[]{result.getSuccessCount(), dimensionName}).withStyle(ChatFormatting.GREEN), true);
                }
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u7ba1\u7406\u5458 {} \u5728\u7ef4\u5ea6 {} \u6dfb\u52a0\u4e86 {} \u4e2a\u5f31\u52a0\u8f7d\u533a\u5757", source.getTextName(), dimensionName, result.getSuccessCount());
            }
            if (!result.getAlreadyExistsSameType().isEmpty()) {
                if (result.getAlreadyExistsSameType().size() == 1) {
                    chunk = result.getAlreadyExistsSameType().get(0);
                    source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.already_exists_same_type", (Object[])new Object[]{chunk.x, chunk.z, "\u5f31\u52a0\u8f7d"}).withStyle(ChatFormatting.YELLOW));
                } else {
                    source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.already_exists_same_type_batch", (Object[])new Object[]{result.getAlreadyExistsSameType().size(), "\u5f31\u52a0\u8f7d"}).withStyle(ChatFormatting.YELLOW));
                }
            }
            if (!result.getAlreadyExistsDifferentType().isEmpty()) {
                if (result.getAlreadyExistsDifferentType().size() == 1) {
                    chunk = result.getAlreadyExistsDifferentType().get(0);
                    source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.already_exists_different_type", (Object[])new Object[]{chunk.x, chunk.z, "\u5f3a\u52a0\u8f7d", "\u5f31\u52a0\u8f7d"}).withStyle(ChatFormatting.RED));
                } else {
                    source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.already_exists_different_type_batch", (Object[])new Object[]{result.getAlreadyExistsDifferentType().size(), "\u5f3a\u52a0\u8f7d", "\u5f31\u52a0\u8f7d"}).withStyle(ChatFormatting.RED));
                }
            }
            if (result.getFailureCount() > 0) {
                source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.lazy.batch_failed", (Object[])new Object[]{result.getFailureCount()}).withStyle(ChatFormatting.RED));
            }
            return result.getSuccessCount() > 0 ? 1 : 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.lazy.error", (Object[])new Object[]{e.getMessage()}).withStyle(ChatFormatting.RED));
            AshenWitchBroom.WRAPPED_LOGGER.error("\u6267\u884c\u6dfb\u52a0\u5f31\u52a0\u8f7d\u533a\u5757\u6307\u4ee4\u65f6\u53d1\u751f\u9519\u8bef", e);
            return 0;
        }
    }

    private static int executeChunksAddTicking(CommandContext<CommandSourceStack> context) {
        try {
            ChunkPos chunk;
            int[] args;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            int x = IntegerArgumentType.getInteger(context, (String)"x");
            int z = IntegerArgumentType.getInteger(context, (String)"z");
            try {
                int w = IntegerArgumentType.getInteger(context, (String)"w");
                int h = IntegerArgumentType.getInteger(context, (String)"h");
                args = new int[]{x, z, w, h};
            }
            catch (IllegalArgumentException e) {
                args = new int[]{x, z};
            }
            ServerLevel level = source.getLevel();
            String dimensionName = level.dimension().location().toString();
            List<ChunkPos> chunks = BroomChunkTicketManager.parseCoordinateArgs(args);
            if (chunks.isEmpty()) {
                source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.ticking.invalid_coordinates").withStyle(ChatFormatting.RED));
                return 0;
            }
            BroomChunkTicketManager.BatchOperationResult result = BroomChunkTicketManager.getInstance().addTickingLoadedChunksBatch(level, chunks);
            if (result.getSuccessCount() > 0) {
                if (result.getSuccessCount() == 1) {
                    chunk = result.getSuccessChunks().get(0);
                    source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.add.ticking.success", (Object[])new Object[]{chunk.x, chunk.z, dimensionName}).withStyle(ChatFormatting.GREEN), true);
                } else {
                    source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.add.ticking.batch_success", (Object[])new Object[]{result.getSuccessCount(), dimensionName}).withStyle(ChatFormatting.GREEN), true);
                }
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u7ba1\u7406\u5458 {} \u5728\u7ef4\u5ea6 {} \u6dfb\u52a0\u4e86 {} \u4e2a\u5f3a\u52a0\u8f7d\u533a\u5757", source.getTextName(), dimensionName, result.getSuccessCount());
            }
            if (!result.getAlreadyExistsSameType().isEmpty()) {
                if (result.getAlreadyExistsSameType().size() == 1) {
                    chunk = result.getAlreadyExistsSameType().get(0);
                    source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.already_exists_same_type", (Object[])new Object[]{chunk.x, chunk.z, "\u5f3a\u52a0\u8f7d"}).withStyle(ChatFormatting.YELLOW));
                } else {
                    source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.already_exists_same_type_batch", (Object[])new Object[]{result.getAlreadyExistsSameType().size(), "\u5f3a\u52a0\u8f7d"}).withStyle(ChatFormatting.YELLOW));
                }
            }
            if (!result.getAlreadyExistsDifferentType().isEmpty()) {
                if (result.getAlreadyExistsDifferentType().size() == 1) {
                    chunk = result.getAlreadyExistsDifferentType().get(0);
                    source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.already_exists_different_type", (Object[])new Object[]{chunk.x, chunk.z, "\u5f31\u52a0\u8f7d", "\u5f3a\u52a0\u8f7d"}).withStyle(ChatFormatting.RED));
                } else {
                    source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.already_exists_different_type_batch", (Object[])new Object[]{result.getAlreadyExistsDifferentType().size(), "\u5f31\u52a0\u8f7d", "\u5f3a\u52a0\u8f7d"}).withStyle(ChatFormatting.RED));
                }
            }
            if (result.getFailureCount() > 0) {
                source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.ticking.batch_failed", (Object[])new Object[]{result.getFailureCount()}).withStyle(ChatFormatting.RED));
            }
            return result.getSuccessCount() > 0 ? 1 : 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.add.ticking.error", (Object[])new Object[]{e.getMessage()}).withStyle(ChatFormatting.RED));
            AshenWitchBroom.WRAPPED_LOGGER.error("\u6267\u884c\u6dfb\u52a0\u5f3a\u52a0\u8f7d\u533a\u5757\u6307\u4ee4\u65f6\u53d1\u751f\u9519\u8bef", e);
            return 0;
        }
    }

    private static int executeChunksDel(CommandContext<CommandSourceStack> context) {
        try {
            int[] args;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            int x = IntegerArgumentType.getInteger(context, (String)"x");
            int z = IntegerArgumentType.getInteger(context, (String)"z");
            try {
                int w = IntegerArgumentType.getInteger(context, (String)"w");
                int h = IntegerArgumentType.getInteger(context, (String)"h");
                args = new int[]{x, z, w, h};
            }
            catch (IllegalArgumentException e) {
                args = new int[]{x, z};
            }
            ServerLevel level = source.getLevel();
            String dimensionName = level.dimension().location().toString();
            List<ChunkPos> chunks = BroomChunkTicketManager.parseCoordinateArgs(args);
            if (chunks.isEmpty()) {
                source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.del.invalid_coordinates").withStyle(ChatFormatting.RED));
                return 0;
            }
            BroomChunkTicketManager.BatchOperationResult result = BroomChunkTicketManager.getInstance().removeLoadedChunksBatch(level, chunks, null);
            if (result.getSuccessCount() > 0) {
                if (result.getSuccessCount() == 1) {
                    ChunkPos chunk = result.getSuccessChunks().get(0);
                    source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.del.success", (Object[])new Object[]{chunk.x, chunk.z, dimensionName}).withStyle(ChatFormatting.GREEN), true);
                } else {
                    source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.del.batch_success", (Object[])new Object[]{result.getSuccessCount(), dimensionName}).withStyle(ChatFormatting.GREEN), true);
                }
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u7ba1\u7406\u5458 {} \u5728\u7ef4\u5ea6 {} \u5220\u9664\u4e86 {} \u4e2a\u533a\u5757", source.getTextName(), dimensionName, result.getSuccessCount());
            }
            if (result.getFailureCount() > 0) {
                source.sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.del.batch_failed", (Object[])new Object[]{result.getFailureCount()}).withStyle(ChatFormatting.RED));
            }
            return result.getSuccessCount() > 0 ? 1 : 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.del.error", (Object[])new Object[]{e.getMessage()}).withStyle(ChatFormatting.RED));
            AshenWitchBroom.WRAPPED_LOGGER.error("\u6267\u884c\u5220\u9664\u533a\u5757\u6307\u4ee4\u65f6\u53d1\u751f\u9519\u8bef", e);
            return 0;
        }
    }

    private static int executeChunksList(CommandContext<CommandSourceStack> context) {
        try {
            List<BroomChunkTicketManager.ChunkRegion> weakRegions;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.getLevel();
            String dimensionName = level.dimension().location().toString();
            int[] stats = BroomChunkTicketManager.getInstance().getStatistics(level);
            int total = stats[0];
            int strongCount = stats[1];
            int weakCount = stats[2];
            if (total == 0) {
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.list.empty", (Object[])new Object[]{dimensionName}).withStyle(ChatFormatting.YELLOW), false);
                return 1;
            }
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.list.title", (Object[])new Object[]{dimensionName}).withStyle(ChatFormatting.GREEN), false);
            List<BroomChunkTicketManager.ChunkRegion> strongRegions = BroomChunkTicketManager.getInstance().getGroupedChunksByType(level, true);
            if (!strongRegions.isEmpty()) {
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.list.ticking_header").withStyle(ChatFormatting.AQUA), false);
                for (BroomChunkTicketManager.ChunkRegion region : strongRegions) {
                    if (region.getChunkCount() == 1) {
                        ChunkPos chunk = region.getChunks().get(0);
                        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.list.ticking_entry", (Object[])new Object[]{chunk.x, chunk.z}).withStyle(ChatFormatting.GRAY), false);
                        continue;
                    }
                    source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.list.ticking_region", (Object[])new Object[]{region.getMinX(), region.getMinZ(), region.getMaxX(), region.getMaxZ()}).withStyle(ChatFormatting.GRAY), false);
                }
            }
            if (!(weakRegions = BroomChunkTicketManager.getInstance().getGroupedChunksByType(level, false)).isEmpty()) {
                source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.list.lazy_header").withStyle(ChatFormatting.YELLOW), false);
                for (BroomChunkTicketManager.ChunkRegion region : weakRegions) {
                    if (region.getChunkCount() == 1) {
                        ChunkPos chunk = region.getChunks().get(0);
                        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.list.lazy_entry", (Object[])new Object[]{chunk.x, chunk.z}).withStyle(ChatFormatting.GRAY), false);
                        continue;
                    }
                    source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.list.lazy_region", (Object[])new Object[]{region.getMinX(), region.getMinZ(), region.getMaxX(), region.getMaxZ()}).withStyle(ChatFormatting.GRAY), false);
                }
            }
            source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.list.total", (Object[])new Object[]{total, strongCount, weakCount}).withStyle(ChatFormatting.GREEN), false);
            AshenWitchBroom.WRAPPED_LOGGER.debug("\u7ba1\u7406\u5458 {} \u67e5\u770b\u4e86\u7ef4\u5ea6 {} \u7684\u533a\u5757\u5217\u8868\uff0c\u5171 {} \u4e2a\u533a\u5757", source.getTextName(), dimensionName, total);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.ashenwitchbroom.chunks.list.error", (Object[])new Object[]{e.getMessage()}).withStyle(ChatFormatting.RED));
            AshenWitchBroom.WRAPPED_LOGGER.error("\u6267\u884c\u5217\u8868\u533a\u5757\u6307\u4ee4\u65f6\u53d1\u751f\u9519\u8bef", e);
            return 0;
        }
    }

    private static int executeChunksHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.help.title").withStyle(ChatFormatting.GOLD), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.help.add_lazy").withStyle(ChatFormatting.GREEN), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.help.add_ticking").withStyle(ChatFormatting.GREEN), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.help.del").withStyle(ChatFormatting.GREEN), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.help.list").withStyle(ChatFormatting.GREEN), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.help.help").withStyle(ChatFormatting.GREEN), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.help.note").withStyle(ChatFormatting.YELLOW), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.help.coordinate_note").withStyle(ChatFormatting.YELLOW), false);
        source.sendSuccess(() -> Component.translatable((String)"command.ashenwitchbroom.chunks.help.batch_note").withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static /* synthetic */ Component lambda$processCleanupResults$66(Component removedCountComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.success_with_removed", (Object[])new Object[]{removedCountComponent});
    }

    private static /* synthetic */ Component lambda$processCleanupResults$64(Component removedComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.cleaned_brooms", (Object[])new Object[]{removedComponent});
    }

    private static /* synthetic */ Component lambda$processCleanupResults$63(Component validComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.valid_brooms", (Object[])new Object[]{validComponent});
    }

    private static /* synthetic */ Component lambda$processCleanupResults$62(Component totalComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.total_brooms", (Object[])new Object[]{totalComponent});
    }

    private static /* synthetic */ Component lambda$executeCleanupForPlayer$53(ServerPlayer player, Component broomCountComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.cleanup.player_broom_count", (Object[])new Object[]{player.getDisplayName().getString(), broomCountComponent});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$43(Component inventoryStatus) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.inventory_summon", (Object[])new Object[]{inventoryStatus.getString()});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$42(Component crossDimensionStatus) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.cross_dimension_summon", (Object[])new Object[]{crossDimensionStatus.getString()});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$41(Component worldStatus) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.world_summon", (Object[])new Object[]{worldStatus.getString()});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$40(Component nearbyStatus) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.nearby_summon", (Object[])new Object[]{nearbyStatus.getString()});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$37(Component storedComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.stored", (Object[])new Object[]{storedComponent});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$36(String dimensionName, Component currentDimensionComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.current_dimension", (Object[])new Object[]{dimensionName, currentDimensionComponent});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$35(int nearbyRange, Component nearbyComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.nearby", (Object[])new Object[]{nearbyRange, nearbyComponent});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$34(Component inventoryComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.inventory", (Object[])new Object[]{inventoryComponent});
    }

    private static /* synthetic */ Component lambda$executeStatsForPlayer$33(Component totalComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.stats.total", (Object[])new Object[]{totalComponent});
    }

    private static /* synthetic */ Component lambda$outputDetectionResults$20(Component distanceComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.detect.distance", (Object[])new Object[]{distanceComponent});
    }

    private static /* synthetic */ Component lambda$outputDetectionResults$15(Component indexComponent, BroomData broom) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.detect.broom_index", (Object[])new Object[]{indexComponent, broom.getBroomName()});
    }

    private static /* synthetic */ Component lambda$outputDetectionResults$13(ServerPlayer player, Component broomCountComponent) {
        return Component.translatable((String)"command.ashenwitchbroom.broom.detect.player_count", (Object[])new Object[]{player.getDisplayName().getString(), broomCountComponent});
    }

    private static class BroomDetectionResult {
        public final int index;
        public final BroomData broomData;
        public final ServerLevel level;
        public final ServerPlayer player;
        public String statusKey = "command.ashenwitchbroom.broom.detect.status_checking";

        public BroomDetectionResult(int index, BroomData broomData, ServerLevel level, ServerPlayer player) {
            this.index = index;
            this.broomData = broomData;
            this.level = level;
            this.player = player;
        }
    }

    private static class BroomCleanupResult {
        public final int index;
        public final BroomData broomData;
        public boolean isValid = false;
        public boolean verificationComplete = false;

        public BroomCleanupResult(int index, BroomData broomData) {
            this.index = index;
            this.broomData = broomData;
        }
    }
}

