/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.item;

import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.data.BroomDataManager;
import com.magicbroom.examplemod.entity.MajoBroomEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MajoBroomItem
extends Item {
    public MajoBroomItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        if (player != null && !level.isClientSide) {
            BlockPos broomPos = pos.above();
            Vec3 spawnPos = new Vec3((double)broomPos.getX() + 0.5, (double)broomPos.getY(), (double)broomPos.getZ() + 0.5);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                String broomName = BroomDataManager.generateUniqueBroomName(serverLevel, player.getUUID());
                MajoBroomEntity broomEntity = new MajoBroomEntity((EntityType)AshenWitchBroom.MAJO_BROOM_ENTITY.get(), level);
                broomEntity.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
                broomEntity.setYRot(player.getYRot());
                broomEntity.setBroomInfo(broomName, player.getUUID());
                level.addFreshEntity((Entity)broomEntity);
                BroomDataManager.addBroom(serverLevel, player.getUUID(), broomName, (ResourceKey<Level>)level.dimension(), broomPos, broomEntity.getUUID());
                player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.broom_placed", (Object[])new Object[]{broomName}));
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u73a9\u5bb6 {} \u5728\u4f4d\u7f6e ({}, {}, {}) \u53ec\u5524\u626b\u5e1a '{}'", player.getName().getString(), level.dimension().location(), pos, broomName);
            }
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }
}

