/*
 * Decompiled with CFR 0.152.
 */
package com.magicbroom.examplemod.network;

import com.magicbroom.examplemod.core.AshenWitchBroom;
import com.magicbroom.examplemod.entity.MajoBroomEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class BroomMountPackets {

    public record BroomMountResponsePack(int entityId, boolean mount, boolean success, double x, double y, double z, float yaw, float pitch) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<BroomMountResponsePack> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"ashenwitchbroom", (String)"broom_mount_response"));
        public static final StreamCodec<RegistryFriendlyByteBuf, BroomMountResponsePack> STREAM_CODEC = StreamCodec.ofMember(BroomMountResponsePack::encode, BroomMountResponsePack::new);

        public BroomMountResponsePack(RegistryFriendlyByteBuf buffer) {
            this(buffer.readVarInt(), buffer.readBoolean(), buffer.readBoolean(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readFloat(), buffer.readFloat());
        }

        public void encode(RegistryFriendlyByteBuf buffer) {
            buffer.writeVarInt(this.entityId);
            buffer.writeBoolean(this.mount);
            buffer.writeBoolean(this.success);
            buffer.writeDouble(this.x);
            buffer.writeDouble(this.y);
            buffer.writeDouble(this.z);
            buffer.writeFloat(this.yaw);
            buffer.writeFloat(this.pitch);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handleClient(BroomMountResponsePack packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.getInstance();
                if (mc.player == null || mc.level == null) {
                    return;
                }
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u5ba2\u6237\u7aef\u6536\u5230\u670d\u52a1\u7aef{}\u54cd\u5e94\uff1a\u5b9e\u4f53ID {} - {}", packet.mount ? "\u4e0a\u9a6c" : "\u4e0b\u9a6c", packet.entityId, packet.success ? "\u5141\u8bb8" : "\u62d2\u7edd");
                if (!packet.success) {
                    AshenWitchBroom.WRAPPED_LOGGER.debug("\u5ba2\u6237\u7aef\u6536\u5230\u670d\u52a1\u7aef\u62d2\u7edd{}\u8bf7\u6c42", packet.mount ? "\u4e0a\u9a6c" : "\u4e0b\u9a6c");
                    return;
                }
                Entity entity = mc.level.getEntity(packet.entityId);
                if (!(entity instanceof MajoBroomEntity)) {
                    AshenWitchBroom.WRAPPED_LOGGER.warn("\u5ba2\u6237\u7aef\u54cd\u5e94\u5904\u7406\u5931\u8d25\uff1a\u5b9e\u4f53ID {} \u4e0d\u662f\u626b\u5e1a\u5b9e\u4f53", packet.entityId);
                    return;
                }
                MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
                if (packet.mount) {
                    if (!broomEntity.isVehicle() && !mc.player.isPassenger()) {
                        mc.player.startRiding((Entity)broomEntity);
                        AshenWitchBroom.WRAPPED_LOGGER.debug("\u5ba2\u6237\u7aef\u6267\u884c\u4e0a\u9a6c\uff1a\u73a9\u5bb6\u9a91\u4e58\u626b\u5e1a {}", broomEntity.getBroomName());
                    }
                } else if (mc.player.getVehicle() == broomEntity) {
                    broomEntity.setDeltaMovement(0.0, 0.0, 0.0);
                    mc.player.stopRiding();
                    broomEntity.setPos(packet.x, packet.y, packet.z);
                    broomEntity.setYRot(packet.yaw);
                    broomEntity.setXRot(packet.pitch);
                    AshenWitchBroom.WRAPPED_LOGGER.debug("\u5ba2\u6237\u7aef\u6267\u884c\u4e0b\u9a6c\uff1a\u73a9\u5bb6\u4ece\u626b\u5e1a {} \u4e0b\u9a6c\uff0c\u4f4d\u7f6e\u540c\u6b65\u5230 ({}, {}, {})\uff0c\u65cb\u8f6c\u540c\u6b65\u5230 (yaw: {}, pitch: {})", broomEntity.getBroomName(), packet.x, packet.y, packet.z, Float.valueOf(packet.yaw), Float.valueOf(packet.pitch));
                }
            });
        }
    }

    public record BroomMountRequestPack(int entityId, boolean mount) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<BroomMountRequestPack> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"ashenwitchbroom", (String)"broom_mount_request"));
        public static final StreamCodec<RegistryFriendlyByteBuf, BroomMountRequestPack> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, BroomMountRequestPack::entityId, (StreamCodec)ByteBufCodecs.BOOL, BroomMountRequestPack::mount, BroomMountRequestPack::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handleServer(BroomMountRequestPack packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                ServerPlayer player = (ServerPlayer)context.player();
                ServerLevel level = player.serverLevel();
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u670d\u52a1\u7aef\u6536\u5230\u73a9\u5bb6 {} \u7684{}\u8bf7\u6c42\uff0c\u5b9e\u4f53ID: {}", player.getName().getString(), packet.mount ? "\u4e0a\u9a6c" : "\u4e0b\u9a6c", packet.entityId);
                Entity entity = level.getEntity(packet.entityId);
                if (!(entity instanceof MajoBroomEntity)) {
                    AshenWitchBroom.WRAPPED_LOGGER.warn("\u670d\u52a1\u7aef\u9a8c\u8bc1\u5931\u8d25\uff1a\u5b9e\u4f53ID {} \u4e0d\u662f\u626b\u5e1a\u5b9e\u4f53", packet.entityId);
                    return;
                }
                MajoBroomEntity broomEntity = (MajoBroomEntity)entity;
                boolean success = false;
                if (packet.mount) {
                    if (broomEntity.getOwnerUUID() != null && !broomEntity.getOwnerUUID().equals(player.getUUID())) {
                        String ownerName = "\u672a\u77e5\u73a9\u5bb6";
                        ServerPlayer ownerPlayer = player.getServer().getPlayerList().getPlayer(broomEntity.getOwnerUUID());
                        if (ownerPlayer != null) {
                            ownerName = ownerPlayer.getName().getString();
                        }
                        player.sendSystemMessage((Component)Component.translatable((String)"message.ashenwitchbroom.using_others_broom", (Object[])new Object[]{ownerName, broomEntity.getBroomName()}));
                        AshenWitchBroom.WRAPPED_LOGGER.debug("\u73a9\u5bb6 {} \u6b63\u5728\u4f7f\u7528 {} \u7684\u626b\u5e1a '{}'", player.getName().getString(), ownerName, broomEntity.getBroomName());
                    }
                    if (!broomEntity.isVehicle() && !player.isPassenger()) {
                        player.startRiding((Entity)broomEntity);
                        success = true;
                        AshenWitchBroom.WRAPPED_LOGGER.debug("\u670d\u52a1\u7aef\u6267\u884c\u4e0a\u9a6c\u6210\u529f\uff1a\u73a9\u5bb6 {} \u9a91\u4e58\u626b\u5e1a {}", player.getName().getString(), broomEntity.getBroomName());
                    } else {
                        AshenWitchBroom.WRAPPED_LOGGER.debug("\u670d\u52a1\u7aef\u4e0a\u9a6c\u5931\u8d25\uff1a\u626b\u5e1a\u5df2\u6709\u4e58\u5ba2\u6216\u73a9\u5bb6\u5df2\u5728\u9a91\u4e58\u72b6\u6001");
                    }
                } else if (player.getVehicle() == broomEntity) {
                    player.stopRiding();
                    success = true;
                    if (broomEntity.getBroomName() != null && broomEntity.getOwnerUUID() != null) {
                        broomEntity.updateBroomPositionSync();
                    }
                    ClientboundTeleportEntityPacket teleportPacket = new ClientboundTeleportEntityPacket((Entity)broomEntity);
                    player.connection.send((Packet)teleportPacket);
                    AshenWitchBroom.WRAPPED_LOGGER.debug("\u670d\u52a1\u7aef\u6267\u884c\u4e0b\u9a6c\u6210\u529f\u5e76\u53d1\u9001Teleport\u5305\uff1a\u73a9\u5bb6 {} -> \u626b\u5e1a {}", player.getName().getString(), broomEntity.getBroomName());
                } else {
                    AshenWitchBroom.WRAPPED_LOGGER.debug("\u670d\u52a1\u7aef\u4e0b\u9a6c\u5931\u8d25\uff1a\u73a9\u5bb6\u4e0d\u5728\u8be5\u626b\u5e1a\u4e0a");
                }
                BroomMountResponsePack response = new BroomMountResponsePack(packet.entityId, packet.mount, success, broomEntity.getX(), broomEntity.getY(), broomEntity.getZ(), broomEntity.getYRot(), broomEntity.getXRot());
                context.reply((CustomPacketPayload)response);
                AshenWitchBroom.WRAPPED_LOGGER.debug("\u670d\u52a1\u7aef\u53d1\u9001{}\u54cd\u5e94\u7ed9\u73a9\u5bb6 {}\uff1a{}", packet.mount ? "\u4e0a\u9a6c" : "\u4e0b\u9a6c", player.getName().getString(), success ? "\u5141\u8bb8" : "\u62d2\u7edd");
            });
        }
    }
}

